/* ------- */
/* mconf.h */
/* ------- */
# ifdef __MCONF_H__
#	/* Do nothing. */
# else
#	define	__MCONF_H__

/*	Common include file for math routines
 *
 *
 * SYNOPSIS:
 *
 * #include "mconf.h"
 *
 *
 *
 * DESCRIPTION:
 *
 * This file contains definitions for error codes that are
 * passed to the common error handling routine mtherr()
 * (which see).
 *
 * The file also includes a conditional assembly definition
 * for the type of computer arithmetic (IEEE, DEC, Motorola
 * IEEE, or UNKnown).
 *
 * For Digital Equipment PDP-11 and VAX computers, certain
 * IBM systems, and others that use numbers with a 56-bit
 * significand, the symbol DEC should be defined.  In this
 * mode, most floating point constants are given as arrays
 * of octal integers to eliminate decimal to binary conversion
 * errors that might be introduced by the compiler.
 *
 * For computers, such as IBM PC, that follow the IEEE
 * Standard for Binary Floating Point Arithmetic (ANSI/IEEE
 * Std 754-1985), the symbol IBMPC should be defined.  These
 * numbers have 53-bit significands.  In this mode, constants
 * are provided as arrays of hexadecimal 16 bit integers.
 *
 * To accommodate other types of computer arithmetic, all
 * constants are also provided in a normal decimal radix
 * which one can hope are correctly converted to a suitable
 * format by the available C language compiler.  To invoke
 * this mode, the symbol UNK is defined.
 *
 * An important difference among these modes is a predefined
 * set of machine arithmetic constants for each.  The numbers
 * MACHEP (the machine roundoff error), MAXNUM (largest number
 * represented), and several other parameters are preset by
 * the configuration symbol.  Check the file const.c to
 * ensure that these values are correct for your computer.
 *
 * For ANSI C compatibility, define ANSIC equal to 1.  Currently
 * this affects only the atan2() function and others that use it.
 */
/*
Cephes Math Library Release 2.1:  January, 1989
Copyright 1984, 1987, 1989 by Stephen L. Moshier
Direct inquiries to 30 Frost Street, Cambridge, MA 02140
*/


/* Constant definitions for math error conditions
 */

#define DOMAIN		1	/* argument domain error */
#define SING		2	/* argument singularity */
#define OVERFLOW	3	/* overflow range error */
#define UNDERFLOW	4	/* underflow range error */
#define TLOSS		5	/* total loss of precision */
#define PLOSS		6	/* partial loss of precision */

#define EDOM		33
#define ERANGE		34

typedef struct CmplxDStru
	{
	double r;
	double i;
	}cmplx;

/* Type of computer arithmetic */

/* PDP-11, Pro350, VAX:
 */
/*define DEC 1*/

/* Intel IEEE, low order words come first:
 */
#define IBMPC 1

/* Motorola IEEE, high order words come first
 * (Sun workstation):
 */
/*define MIEEE 1*/

/* UNKnown arithmetic, invokes coefficients given in
 * normal decimal format.  Beware of range boundary
 * problems (MACHEP, MAXLOG, etc. in const.c) and
 * roundoff problems in pow.c:
 /*define UNK 1*/

/* Define 1 for ANSI C atan2() function
 * See atan.c and clog.c.
 */
#define ANSIC 1

/*define VOLATILE volatile*/
#define VOLATILE

#define	DENORMAL	1

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	acos F((double));
extern	double	acosh F((double));
extern	double	airy F((double, double *, double *, double *, double *));
extern	double	asin F((double));
extern	double	asinh F((double));
extern	double	atan F((double));
extern	double	atan2 F((double, double));
extern	double	atanh F((double));
extern	double	bdtr F((int, int, double));
extern	double	bdtrc F((int, int, double));
extern	double	bdtri F((int, int, double));
extern	double	beta F((double, double));
extern	double	btdtr F((double, double, double));
extern	double	cabs F((void *));
extern	int	cacos F((void *, void *));
extern	int	cadd F((void *, void *, void *));
extern	int	casin F((void *, void *));
extern	int	catan F((void *, void *));
extern	double	cbrt F((double));
extern	int	cchsh F((double, double *, double *));
extern	int	ccos F((void *, void *));
extern	int	ccot F((void *, void *));
extern	int	cdiv F((void *, void *, void *));
extern	double	ceil F((double));
extern	int	cexp F((void *, void *));
extern	double	chbevl F((double, double *, int));
extern	double	chdtr F((double, double));
extern	double	chdtrc F((double, double));
extern	double	chdtri F((double, double));
extern	int	clog F((void *, void *));
extern	int	cmov F((short *, short *));
extern	int	cmul F((void *, void *, void *));
extern	int	cneg F((void *));
extern	double	cos F((double));
extern	double	cosdg F((double));
extern	double	cosh F((double));
extern	double	cot F((double));
extern	double	cotdg F((double));
extern	int	csin F((void *, void *));
extern	int	csqrt F((void *, void *));
extern	int	csub F((void *, void *, void *));
extern	int	ctan F((void *, void *));
extern	double	ctans F((void *));
extern	double	dawsn F((double));
extern	void	drand F((double *));
extern	double	ellie F((double, double));
extern	double	ellik F((double, double));
extern	double	ellpe F((double));
extern	double	ellpj F((double, double, double *, double *, double *, double *));
extern	double	ellpk F((double));
extern	double	erf F((double));
extern	double	erfc F((double));
extern	double	exp F((double));
extern	double	exp10 F((double));
extern	double	exp2 F((double));
extern	double	expn F((int, double));
extern	double	fabs F((double));
extern	double	fac F((int));
extern	double	fdtr F((int, int, double));
extern	double	fdtrc F((int, int, double));
extern	double	fdtri F((int, int, double));
extern	double	floor F((double));
extern	int	fresnl F((double, double *, double *));
extern	double	frexp F((double, int *));
extern	double	gamma F((double));
extern	double	gdtr F((double, double, double));
extern	double	gdtrc F((double, double, double));
extern	double	hyp2f0 F((double, double, double, int, double *));
extern	double	hyp2f1 F((double, double, double, double));
extern	double	hyperg F((double, double, double));
extern	double	i0 F((double));
extern	double	i0e F((double));
extern	double	i1 F((double));
extern	double	i1e F((double));
extern	double	igam F((double, double));
extern	double	igamc F((double, double));
extern	double	igami F((double, double));
extern	double	incbet F((double, double, double));
extern	double	incbi F((double, double, double));
extern	double	iv F((double, double));
extern	double	j0 F((double));
extern	double	j1 F((double));
extern	double	jn F((int, double));
extern	double	_j0 F((double));
extern	double	_j1 F((double));
extern	double	_jn F((int, double));
extern	double	jv F((double, double));
extern	double	k0 F((double));
extern	double	k0e F((double));
extern	double	k1 F((double));
extern	double	k1e F((double));
extern	double	kn F((int, double));
extern	double	ldexp F((double, int));
extern	double	lgam F((double));
extern	double	log F((double));
extern	double	log10 F((double));
extern	double	log2 F((double));
extern	void	mtherr F((char *, int));
extern	double	nbdtr F((int, int, double));
extern	double	nbdtrc F((int, int, double));
extern	double	ndtr F((double));
extern	double	ndtri F((double));
extern	double	onef2 F((double, double, double, double, double *));
extern	double	p1evl F((double, void *, int));
extern	double	pdtr F((int, double));
extern	double	pdtrc F((int, double));
extern	double	pdtri F((int, double));
extern	double	polevl F((double, void *, int));
extern	double	pow F((double, double));
extern	double	powi F((double, int));
extern	double	psi F((double));
extern	double	radian F((double, double, double));
extern	double	redupi F((double));
extern	double	rgamma F((double));
extern	double	round F((double));
extern	int	shichi F((double, double *, double *));
extern	int	sici F((double, double *, double *));
extern	double	sin F((double));
extern	double	sindg F((double));
extern	double	sinh F((double));
extern	double	spence F((double));
extern	double	sqrt F((double));
extern	double	stdtr F((int, double));
extern	double	struve F((double, double));
extern	double	tan F((double));
extern	double	tandg F((double));
extern	double	tanh F((double));
extern	double	threef0 F((double, double, double, double, double *));
extern	double	y0 F((double));
extern	double	y1 F((double));
extern	double	yn F((int, double));
extern	double	_y0 F((double));
extern	double	_y1 F((double));
extern	double	_yn F((int, double));
extern	double	zeta F((double, double));
extern	double	zetac F((double));
/*double cabs F((struct *)); */
/*int cacos F((struct *, struct *)); */
/*int cadd F((struct *, struct *, struct *)); */

# undef F
/* INDENT ON */

# endif					/* <<< __MCONF_H__ >>> */
