// TestJigDlg.h : header file
//

#include "TestObj.h"
#include "TestJig.h"

/////////////////////////////////////////////////////
class CTestJigDlg : public CDialog
{
// Construction
public:
	CTestJigDlg(CWnd* pParent = NULL);	// standard constructor

	CTestObject *m_pTest;

	enum eTestType{
		TEST_NOTHING,
		TEST_MEMCPY_INT8,
		TEST_MEMCPY_INT16,
		TEST_MEMCPY_INT32,
		TEST_MEMCPY_INT64,
		TEST_MEMCPY_INT256,
		TEST_MEMCPY_FLOAT8,
		TEST_MEMCPY_FLOAT16,
		TEST_MEMCPY_FLOAT32,
		TEST_MEMCPY_FLOAT64
	} m_TestType;

	BOOL m_bMMXPresent;
	BOOL m_bColdCache;
	BOOL m_bSelfWarming;
	UINT m_nBufferSize;
	
	void EnableAllItems(BOOL bEnable = TRUE); 
	void EnableTestItems(BOOL bEnable = TRUE);
	void Initialize();
	void RunTest();
	void CreateTestObject(); 
	void DestroyTestObject();

// Dialog Data
	//{{AFX_DATA(CTestJigDlg)
	enum { IDD = IDD_TESTJIG_DIALOG };
	CButton	m_cbxSelfWarming;
	CButton	m_cbxMMXPresent;
	CButton	m_cbxColdCache;
	CListBox	m_lbOutput;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTestJigDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CTestJigDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnBtnClear();
	afx_msg void OnCbxColdCache();
	afx_msg void OnCbxMMXPresent();
	afx_msg void OnRdoint8();
	afx_msg void OnRdoint64();
	afx_msg void OnRdoint32();
	afx_msg void OnRdoint256();
	afx_msg void OnRdoint16();
	afx_msg void OnRdofloat8();
	afx_msg void OnRdofloat32();
	afx_msg void OnRdofloat64();
	afx_msg void OnBtnrun();
	afx_msg void OnCbxselfwarm();
	afx_msg void OnRdofloat16();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
