// TJDlg.cpp : implementation file
//

#include "stdafx.h"

#include "TestObj.h"
#include "Tests.h"
#include "TJDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////
// CTestJigDlg dialog

CTestJigDlg::CTestJigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestJigDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTestJigDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestJigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestJigDlg)
	DDX_Control(pDX, IDC_CBXSELFWARM, m_cbxSelfWarming);
	DDX_Control(pDX, IDC_CBXMMXPRESENT, m_cbxMMXPresent);
	DDX_Control(pDX, IDC_CBXCOLDCACHE, m_cbxColdCache);
	DDX_Control(pDX, IDC_LIST_OUTPUT, m_lbOutput);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestJigDlg, CDialog)
	//{{AFX_MSG_MAP(CTestJigDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNCLEAR, OnBtnClear)
	ON_BN_CLICKED(IDC_CBXCOLDCACHE, OnCbxColdCache)
	ON_BN_CLICKED(IDC_CBXMMXPRESENT, OnCbxMMXPresent)
	ON_BN_CLICKED(IDC_RDOINT8, OnRdoint8)
	ON_BN_CLICKED(IDC_RDOINT64, OnRdoint64)
	ON_BN_CLICKED(IDC_RDOINT32, OnRdoint32)
	ON_BN_CLICKED(IDC_RDOINT256, OnRdoint256)
	ON_BN_CLICKED(IDC_RDOINT16, OnRdoint16)
	ON_BN_CLICKED(IDC_RDOFLOAT8, OnRdofloat8)
	ON_BN_CLICKED(IDC_RDOFLOAT32, OnRdofloat32)
	ON_BN_CLICKED(IDC_RDOFLOAT64, OnRdofloat64)
	ON_BN_CLICKED(IDC_BTNRUN, OnBtnrun)
	ON_BN_CLICKED(IDC_CBXSELFWARM, OnCbxselfwarm)
	ON_BN_CLICKED(IDC_RDOFLOAT16, OnRdofloat16)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////
BOOL CTestJigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, 
					IDM_ABOUTBOX, strAboutMenu);
	}

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_TestType = TEST_NOTHING;
	m_cbxMMXPresent.SetCheck(0);
	m_bMMXPresent = FALSE;
	m_cbxColdCache.SetCheck(1);
	m_bColdCache = TRUE;
	m_cbxSelfWarming.SetCheck(0);
	m_bSelfWarming = FALSE;
	m_pTest = NULL;
	m_TestType = TEST_NOTHING;

	// TRUE unless you set the focus to a control
	return TRUE;  
}

void CTestJigDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

/////////////////////////////////////////////////////
// If you add a minimize button to your dialog, 
// you will need the code below to draw the icon.  
// For MFC applications using the document/view model,
// this is automatically done for you by the framework.
void CTestJigDlg::OnPaint() 
{
	if (IsIconic())
	{
		// device context for painting
		CPaintDC dc(this); 
		

		SendMessage(
				WM_ICONERASEBKGND, 
				(WPARAM) dc.GetSafeHdc(), 
				0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CTestJigDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////
void CTestJigDlg::OnBtnClear() 
{
	m_lbOutput.ResetContent();

}

void CTestJigDlg::OnCbxColdCache() 
{
	if (m_cbxColdCache.GetCheck() == 1){
		m_bColdCache = TRUE;
	}
	else{
		m_bColdCache = FALSE;
	}
}

void CTestJigDlg::OnCbxMMXPresent() 
{
	if (m_cbxMMXPresent.GetCheck() == 1){
		m_bMMXPresent = TRUE;
	}
	else{
		m_bMMXPresent = FALSE;
	}
}

void CTestJigDlg::OnCbxselfwarm() 
{
	if (m_cbxSelfWarming.GetCheck() == 1){
		m_bSelfWarming = TRUE;
	}
	else{
		m_bSelfWarming = FALSE;
	}
}

void CTestJigDlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CTestJigDlg::OnOK() 
{
	CDialog::OnOK();
}

/////////////////////////////////////////////////////
void CTestJigDlg::RunTest()
{
	if(!m_pTest)
		return;

	// Take care of all the settings
	m_pTest->m_bMMXPresent = m_bMMXPresent;
	m_pTest->m_bColdCache = m_bColdCache;
	m_pTest->m_dwCount = 2048;
	m_pTest->m_pOutBox = &m_lbOutput;

	// Actually run the test
	m_pTest->RunTest();
}

void CTestJigDlg::OnRdoint8()	{ m_TestType = TEST_MEMCPY_INT8; } 
void CTestJigDlg::OnRdoint16()	{ m_TestType = TEST_MEMCPY_INT16; } 
void CTestJigDlg::OnRdoint32()	{ m_TestType = TEST_MEMCPY_INT32; } 
void CTestJigDlg::OnRdoint64()	{ m_TestType = TEST_MEMCPY_INT64; } 
void CTestJigDlg::OnRdoint256()	{ m_TestType = TEST_MEMCPY_INT256; } 
void CTestJigDlg::OnRdofloat8()	{ m_TestType = TEST_MEMCPY_FLOAT8; } 
void CTestJigDlg::OnRdofloat16(){ m_TestType = TEST_MEMCPY_FLOAT16; }
void CTestJigDlg::OnRdofloat32(){ m_TestType = TEST_MEMCPY_FLOAT32; }
void CTestJigDlg::OnRdofloat64(){ m_TestType = TEST_MEMCPY_FLOAT64; } 

void CTestJigDlg::OnBtnrun() 
{
	switch(m_TestType){
		case TEST_MEMCPY_INT8:		m_pTest = new CT_MemCpyInt(8, m_bSelfWarming); 	break;	
		case TEST_MEMCPY_INT16:		m_pTest = new CT_MemCpyInt(16, m_bSelfWarming);	break;
		case TEST_MEMCPY_INT32:		m_pTest = new CT_MemCpyInt(32, m_bSelfWarming); break;
		case TEST_MEMCPY_INT64:		m_pTest = new CT_MemCpyInt(64, m_bSelfWarming); break;
		case TEST_MEMCPY_INT256:	m_pTest = new CT_MemCpyInt(256, m_bSelfWarming); break;
		case TEST_MEMCPY_FLOAT8:	m_pTest = new CT_MemCpyFloat(8, m_bSelfWarming); break;
		case TEST_MEMCPY_FLOAT16:	m_pTest = new CT_MemCpyFloat(16, m_bSelfWarming); break;
		case TEST_MEMCPY_FLOAT32:	m_pTest = new CT_MemCpyFloat(32,m_bSelfWarming); break;
		case TEST_MEMCPY_FLOAT64:	m_pTest = new CT_MemCpyFloat(64, m_bSelfWarming); break;
	}

	if(m_pTest){
		RunTest();
		delete m_pTest;
	}
}




