Listing 5: UNIXThread.cpp
--------------------------------------------------------------------------
// UNIXThread.cpp - UNIX
// multithreading implementation

#include "UNIXThread.h"

void AUNIXThread::EntryPoint(void* param) {
   AUNIXThread* ptr = (AUNIXThread*) param;
   ptr->Run();
   ptr->SetDeadState();
}

AUNIXThread::AUNIXThread() {
   pthread_mutex_init(&mHandleLock,
                      pthread_mutexattr_default);
   pthread_create(&mThread, pthread_attr_default,
                  EntryPoint, (void*)this);
   pthread_detach(mThread);
}

AUNIXThread::~AUNIXThread() {
   if (mState != DEAD) Kill(true);
   pthread_mutex_destroy(&mHandleLock);
}

void AUNIXThread::Kill(BOOL force) {
   LockHandle();
   mState = TERMINATE;
   UnlockHandle();
}

void AUNIXThread::CheckStatus() {
   LockHandle();
   if (mState == TERMINATE) {
      mState = DEAD;
      UnlockHandle();
      pthread_exit((void*) 0);
   }
   UnlockHandle();
}
