/* ============ */
/* xtstfun.h	*/
/* ============ */
// After Cody & Waite and Plauger
#include <stdio.h>
#include <stdlib.h>
//#include <math.h>
#include <time.h>
#include "qfloat.h"
#include "machars.h"
#include "xtstdefs.h"
/* ========================================== */
/* XVerFun - Compares One-Parameter Functions */
/* ========================================== */
void
XVerFun(MACHAR_STRU &MachData,
	const int NumCpr,
	const qfloat LoLim,
	const qfloat HiLim,
	qfloat (*LocalFun)(qfloat, qfloat &),
	char *Label)
{
    int     k, NumHi = 0, NumLo = 0;
    qfloat  XArg, XDelta, XHi, XLo, XRoot, XSqr;
    qfloat  XArgMax, XErrMax, XErrSqr, XRelErr;

    printf("%s\n", Label);
    //xprintf("", LoLim, 40, "\nto\n");
    //xprintf("", HiLim, 40, "\n");
    fflush(NULL);
    /* ----------------------------------------- */
    /* Calculate Step for Arguments to Be Tested */
    /* ----------------------------------------- */

    XDelta = (HiLim - LoLim);
    XDelta /= NumCpr;
    //xprintf("XDelta = ", XDelta, 20, "\n");

    XArgMax = 0;
    XErrMax = 0;
    XErrSqr = 0;

    //qsrand((unsigned int)time(NULL));

    for (k = 0; k < NumCpr; ++k)
    {
	qfloat	XAns1, XAns2, XArg;

	/* Calculate Next Argument */

	XArg = XDelta * xrand() +  XDelta * k + LoLim;

//	printf("\nCall # %d\n", k+1);
//	xprintf("Arg                 = ", XArg,  40, "\n");

	XAns1 = (*LocalFun)(XArg, XAns2);

//	xprintf("Extended Function   = ", XAns1, 40, "\n");
//	xprintf("Function Under Test = ", XAns2, 40, "\n");

	if (XAns1 == 0)
	{
	    XRelErr = 1;
	}
	else
	{
	    XRelErr = (XAns1 - XAns2) / XAns1;
	}

	if (XRelErr < 0)
	{
	    XRelErr = -XRelErr;
	}
	if (XAns1 >= 0)
	{
	    XAns1 = XRelErr;
	}
	else
	{
	    XAns1 = -XRelErr;
	}

	if (XAns1 < 0)
	    ++NumLo;

	else if (XAns1 > 0)
	    ++NumHi;

	if (XErrMax < XRelErr)
	    XErrMax = XRelErr, XArgMax = XArg;

	XErrSqr += XRelErr * XRelErr;

	if (((k+1) % 100) == 0 && isatty(fileno(stderr)))
	{
	    fprintf(stderr, "\tArgument # %4d\r", k+1);
	}
    }

    if (isatty(fileno(stderr)))
    {
	fprintf(stderr, "\n");
	fflush(NULL);
    }

    printf("Result was smaller %d times, equal %d times, "
	   "and larger %d times\n",
	    NumLo, NumCpr - NumLo - NumHi, NumHi);

    if (XErrSqr == 0)
    {
	printf("The maximum relative error = %d ^ -(INF)\n",
		MachData.Radix);
	printf("Estimated loss of base %d significant digits "
		" is 0.00\n", MachData.Radix);
	printf("The root-mean-square relative is %d ^ -(INF)\n",
		MachData.Radix);
	printf("Estimated loss of base %d significant digits "
		" is 0.00\n", MachData.Radix);
    }
    else
    {
	qfloat	ErrDigs, LossDigs, MeanSqrErr;

	ErrDigs = xlog(XErrMax) / xlog(MachData.Radix);

	printf("The maximum relative error of %.10LE"
		" = 2 ^ %.2Lf\n\toccurred for x = %.20LG\n",
		xtold(XErrMax), xtold(ErrDigs), xtold(XArgMax));

	LossDigs = ErrDigs + MachData.FracDigs;

	if (LossDigs <= 0)
	{
	    LossDigs = 0;
	}
	printf("Estimated loss of base %d significant digits "
		" is %.2Lf\n", MachData.Radix, xtold(LossDigs));

	MeanSqrErr = xsqrt(XErrSqr) / (qfloat)NumCpr;
	ErrDigs = xlog(MeanSqrErr) / xlog(MachData.Radix);

	printf("The root-mean-square relative error was "
		"%.10LG = %d ^ %.2Lf\n", xtold(MeanSqrErr),
		MachData.Radix, xtold(ErrDigs));

	LossDigs = ErrDigs + MachData.FracDigs;

	if (LossDigs <= 0)
	{
	    LossDigs = 0;
	}
	printf("Estimated loss of base %d significant digits "
		" is %.2Lf\n", MachData.Radix, xtold(LossDigs));
    }
    printf("\n");
}
