/* ======== */
/* xvsinh.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
// ---------------------
// sinh(x) versus xsinh(x)
// ---------------------
static
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    SinhArg;

    SinhArg = (TYPE)xtold(x);

    pzz = xsinh(SinhArg);

    return NAME(sinh)(SinhArg);
}
// ---------------------
// cosh(x) versus xcosh(x)
// ---------------------
static
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    CoshArg;

    CoshArg = (TYPE)xtold(x);

    pzz = xcosh(CoshArg);

    return NAME(cosh)(CoshArg);
}
// -------------------------------------------------------------
// Main Program to Test sinh/cosh Function versus Extended sinh/cosh
// -------------------------------------------------------------
#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_FUN_1	NAME(sinh)
#define	TEST_FUN_2	NAME(cosh)
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 RadixPow;
    TYPE	 CoshArg, CoshAns, SinhArg, SinhAns;
    char	 Label[128];
    const char  *FunStr1 = MAK_STR(TEST_FUN_1);
    const char  *FunStr2 = MAK_STR(TEST_FUN_2);
    MACHAR_STRU  MachData;
    qfloat	 LoLim, HiLim;

    printf("Test of %s(x) vs. x%s(x) & "
	           "%s(x) vs. x%s(x):\n",
	    FunStr1, FunStr1, FunStr2, FunStr2);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);

    LoLim = 0.0;
    HiLim = 0.5;
    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr1,
		TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", FunStr2,
		TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    LoLim = 3.0;
    HiLim = xlog(MachData.Max);

    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%.5LG, %.5LG)", 	FunStr1,
		TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%.5LG, %.5LG)", FunStr2,
		TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    printf("\nSPECIAL VALUES\n");
    printf("\n%s(x) vs. %s(-x) for random values\n",
	FunStr1, FunStr1);
    for (k = 1; k <= 5; ++k)
    {
	SinhArg = (TYPE) (LDURand() * 3);
	SinhAns = NAME(sinh)(SinhArg) +
		  NAME(sinh)(-SinhArg);
	printf("\tx = %.10Lf, %s(x) + %s(-x) = %.10LG\n",
	    (LDBL) SinhArg, FunStr1, FunStr1,
	    (LDBL) SinhAns);
    }
    RadixPow = (TYPE) 1;

    for (k = 1; k < MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    SinhArg = (TYPE) (LDURand() / RadixPow);
    printf("\n%s(x) - x for small values of x\n", FunStr1);
    for (k = 1; k <= 5; ++k)
    {
	SinhArg /= (TYPE) MachData.Radix;

	SinhAns = NAME(sinh) (SinhArg) - SinhArg;

	printf("\tx = %.10LG, %s(x) - x = %.10LG\n",
	    (LDBL) SinhArg, FunStr1,
	    (LDBL) (SinhAns));
    }
    printf("\n%s(x) vs. %s(-x) for random values\n",
	FunStr2, FunStr2);
    for (k = 1; k <= 5; ++k)
    {
	CoshArg = (TYPE) (LDURand() * 3.0);
	CoshAns = NAME(cosh)(CoshArg) -
		  NAME(cosh)(-CoshArg);
	printf("\tx = %.10Lf, %s(x) - %s(-x) = %.10LG\n",
	    (LDBL) CoshArg, FunStr2, FunStr2,
	    (LDBL) CoshAns);
    }
    printf("\n    Testing underflow in %s "
	   "for very small argument.\n", FunStr1);

    RadixPow = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	RadixPow /= (TYPE) MachData.Radix;

    SinhAns = NAME(sinh)(RadixPow);

    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) RadixPow, FunStr1,
	(LDBL) SinhAns);

    printf("\nBOUNDARY VALUES:\n");

    SinhArg = NAME(log) (MachData.Max) - (TYPE) 1/(TYPE) 4096;

    printf("\nThe following call should not "
	   "trigger an error message:\n");

    SinhAns = NAME(sinh) (SinhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) SinhArg, FunStr1, (LDBL) SinhAns);

    SinhArg = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	SinhArg *= (TYPE) MachData.Radix;

    printf("\nThe following calls might "
	   "trigger error messages:\n");
    SinhAns = NAME(sinh) (SinhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) SinhArg, FunStr1, (LDBL) SinhAns);
    CoshAns = NAME(cosh) (SinhArg);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) SinhArg, FunStr2, (LDBL) CoshAns);

    return (0);
}
