/* ====== */
/* xvjn.h */
/* ====== */
// After Cody & Waite and Plauger
#include "xverfun.h"
#define EXT_FUN   	xjn
#define TST_FUN_0  NAME(_j0)
// --------------------------|
// TST_FUN_0(x) vs. ExtFun(x)|
// --------------------------|
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)(xtold(x));

    pzz = EXT_FUN(0, FunArg);

    return TST_FUN_0(FunArg);
}
#define TST_FUN_1  NAME(_j1)
// --------------------------|
// TST_FUN_1(x) vs. ExtFun(x)|
// --------------------------|
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    FunArg;

    FunArg = (TYPE)(xtold(x));

    pzz = EXT_FUN(1, FunArg);

    return  TST_FUN_1(FunArg);
}
//printf("FunArg = %.10LG, Answer = %.10LG, xf1 = %.10LG\n",
//	(LDBL)FunArg, (LDBL)Answer, xtold(pzz));
//fflush(NULL);
/* -------------------- */
/* First 20 zeros of j0 */
/* -------------------- */
static	double  J0Zeros[] =
    {
	 2.4048256,  5.5200781,  8.6537279, 11.7915335,
	14.9309174, 18.0710639, 21.2116366, 24.3524715,
	27.4934791, 30.6346065, 33.7758202, 36.9170984,
	40.0584258, 43.1997917, 46.3411884, 49.4826099,
	52.6240518, 55.7655108, 58.9069839, 62.0484692
    };
static	const	int	NumJ0Zeros =
	(sizeof(J0Zeros) / sizeof(*J0Zeros));

/* -------------------- */
/* First 20 zeros of j1 */
/* -------------------- */
static	double  J1Zeros[] =
    {
	 3.8317060,  7.0155867, 10.1734705, 13.3236926,
	16.4706303, 19.6158586, 22.7600844, 25.9036721,
	29.0468285, 32.1896799, 35.3323076, 38.4747662,
	41.6170942, 44.7593190, 47.9014609, 51.0435352,
	54.1855536, 57.3275254, 60.4694578, 63.6113567
    };
static	const	int	NumJ1Zeros =
	(sizeof(J1Zeros) / sizeof(*J1Zeros));

/* ==================================================================== */
/* main - Compares library functions jn with extended version in qjn.c	*/
/* ==================================================================== */
#define EXT_FUN_STR	MAK_STR(EXT_FUN)
#define MAK_STR(x)	STR_NAME(x)
#define STR_NAME(x)	#x
#define	TEST_SIZE	1000
int
main()
{
    const
    char	*FunStr1 = MAK_STR(TST_FUN_0),
    		*FunStr2 = MAK_STR(TST_FUN_1);
    char	 Label[128];
    int		 k;
    TYPE	 TestArg, TestAns;
    qfloat	 HiLim, LoLim;
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. %s(x):\n", FunStr1, EXT_FUN_STR);
    MachData = GetMachar();

    printf("There are %d Base %d Significant Digits\n",
	MachData.FracDigs, MachData.Radix);

    LoLim = 0;
    HiLim = 2.25;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 1,
	FunStr1, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 9;
    HiLim = 11;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 2,
	FunStr1, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f1, Label);

    LoLim = 0;
    HiLim = 3;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 3,
	FunStr2, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);
    fflush(NULL);

    LoLim = 11;
    HiLim = 12;
    sprintf(Label, "Test %d: %s(x) for %d values in "
		   "(%.10LG, %.10LG)\n", 4,
	FunStr2, TEST_SIZE, xtold(LoLim), xtold(HiLim));
    XVerFun(MachData, TEST_SIZE, LoLim, HiLim, &f2, Label);

    fflush(NULL);
    printf("\nSPECIAL VALUES:\n");

    printf("\nTesting zeros of %s\n", FunStr1);

    printf("\nZero #\t   %s(z)\t\t%s(0, z)"
		"\t    Absolute Error\n",
		FunStr1, EXT_FUN_STR);

    for (k = 0; k < NumJ0Zeros; ++k)
    {
	qfloat  XTestAns, XAbsErr = 0;

	TestArg  = (TYPE)J0Zeros[k];
	TestAns  = TST_FUN_0(TestArg);
	XTestAns = EXT_FUN(0, TestArg);
	XAbsErr  = xabs(XTestAns - TestAns);
        printf("%3d\t%+.10Le   %+.10Le   %.10Le\n",
		k+1,(LDBL)TestAns,
		xtold(XTestAns), xtold(XAbsErr));
    }

    printf("\nTesting zeros of %s\n", FunStr2);

    printf("\nZero #\t   %s(z)\t\t%s(1, z)"
		"\t    Absolute Error\n",
		FunStr1, EXT_FUN_STR);

    for (k = 0; k < NumJ1Zeros; ++k)
    {
	qfloat  XTestAns, XAbsErr;

	TestArg  = (TYPE)J1Zeros[k];
	TestAns  = TST_FUN_1(TestArg);

	XTestAns = EXT_FUN(1, TestArg);
	XAbsErr  = xabs(XTestAns - TestAns);
        printf("%3d\t%+.10Le   %+.10Le   %.10Le\n",
		k+1,(LDBL)TestAns,
		xtold(XTestAns), xtold(XAbsErr));
    }

    printf("\nTesting the identity "
	   "z = 2J1(z)/(J0(z) + J2(z)) for integral z\n");

    for (k = 1; k <= 10; ++k)
    {
	TYPE	Z;
	Z = 2*NAME(_j1)(k) /
		(NAME(_j0)(k) + NAME(_jn)(2, k));
# if defined(FLT)
	printf("\tz = %2d, F(z) = %.7G\n", k, Z);
# elif defined(DBL)
	printf("\tz = %2d, F(z) = %.16G\n", k, Z);
# else
	printf("\tz = %2d, F(z) = %.19LG\n", k, Z);
# endif
	fflush(NULL);
    }
    printf("\nTesting the identity "
	   "z = 10J5(z)/(J4(z) + J6(z)) for integral z\n");

    for (k = 1; k <= 10; ++k)
    {
	TYPE	Z;
	Z = 10*NAME(_jn)(5, k) /
		(NAME(_jn)(4, k) + NAME(_jn)(6, k));
# if defined(FLT)
	printf("\t%z = %2d, F(z) = %.7G\n", k, Z);
# elif defined(DBL)
	printf("\t%z = %2d, F(z) = %.16G\n", k, Z);
# else
	printf("\t%z = %2d, F(z) = %.19LG\n", k, Z);
# endif
	fflush(NULL);
    }
    return (0);
}
