/* ============ */
/* xverfun2.h	*/
/* ============ */
// After Cody & Waite and Plauger
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "qfloat.h"
#include "machars.h"
#include "xtstdefs.h"
#include "getmachx.h"
/* ==================================================================== */
/* XVerFunXY - Compares Two-Parameter Functions in standard & extended	*/
/* ==================================================================== */
void
XVerFunXY(MACHAR_STRU &MachData,
	const int NumCpr,
	const qfloat LoLim,
	const qfloat HiLim,
	const qfloat YRangeLo,
	const qfloat YRangeHi,
	qfloat (*LocalFun)(qfloat, qfloat, qfloat &),
	char *Label)
{
    int     k, NumHi = 0, NumLo = 0;
    qfloat  XArg, XDelta, XHi, XLo, XRoot, XSqr;
    qfloat  XArgMax, XErrMax, XErrSqr, XRelErr, YArgMax;

    printf("%s\n", Label);
    //xprintf("", LoLim, 40, "\nto\n");
    //xprintf("", HiLim, 40, "\n");
    fflush(NULL);

    /* ----------------------------------------- */
    /* Calculate Step for Arguments to Be Tested */
    /* ----------------------------------------- */
    XDelta = (HiLim - LoLim);
    XDelta /= NumCpr;
    //xprintf("XDelta = ", XDelta, 20, "\n");

    XArgMax = 0;
    XErrMax = 0;
    XErrSqr = 0;
    YArgMax = 0;

    //qsrand((unsigned int)time(NULL));

    for (k = 0; k < NumCpr; ++k)
    {
	qfloat	XAns1, XAns2, XArg, YArg;

	/* Calculate Next X & Y Arguments */

	XArg = XDelta * xrand() + XDelta * k + LoLim;
	YArg = YRangeLo + xrand() * (YRangeHi - YRangeLo);
	XAns1 = (*LocalFun)(XArg, YArg, XAns2);

	if (XAns1 == 0)
	{
		XRelErr = 1;
	}
	else
	{
		XRelErr = (XAns1 - XAns2) / XAns1;
	}
//	xprintf("XArg                = ", XArg,  20, "\n");
//	xprintf("YArg                = ", YArg,  20, "\n");
//	xprintf("Extended Function   = ", XAns2, 20, "\n");
//	xprintf("Function Under Test = ", XAns1, 20, "\n");

	if (XRelErr < 0)
	{
	    XRelErr = -XRelErr;
	}
	XAns1 = XAns1 < 0 ? -XRelErr : XRelErr;

	if (XAns1 < 0)
	    ++NumLo;

	else if (XAns1 > 0)
	    ++NumHi;

	if (XErrMax < XRelErr)
	    XErrMax = XRelErr,
	    XArgMax = (TYPE)(xtold(XArg)),
	    YArgMax = (TYPE)(xtold(YArg));

	XErrSqr += XRelErr * XRelErr;

	if (((k+1) % 100) == 0 && isatty(fileno(stderr)))
	{
	    fprintf(stderr, "\tArgument # %4d\r", k+1);
	}
    }

    if (isatty(fileno(stderr)))
    {
	fprintf(stderr, "\n");
	fflush(NULL);
    }

    printf("Result was smaller %d times, equal %d times, "
	   "and larger %d times\n",
	    NumLo, NumCpr - NumLo - NumHi, NumHi);

    if (XErrSqr == 0)
    {
	printf("The maximum relative error = %d ^ -(INF)\n",
		MachData.Radix);
	printf("Estimated loss of base %d significant digits "
		" is 0.00\n", MachData.Radix);
	printf("The root-mean-square relative is %d ^ -(INF)\n",
		MachData.Radix);
	printf("Estimated loss of base %d significant digits "
		" is 0.00\n", MachData.Radix);
    }
    else
    {
	LDBL	ErrDigs, ErrMax, LossDigs, MeanSqrErr;

	ErrDigs = xtold(xlog(XErrMax) /
		  xlog(MachData.Radix));
	ErrMax = xtold(XErrMax);

	printf("The maximum relative error of %.10LE"
		" = 2 ^ %.2Lf\n"
		"\toccurred for x = %+.20LG\n"
		"\t         and y = %+.20LG\n",
		ErrMax, ErrDigs, xtold(XArgMax),
		xtold(YArgMax));

	LossDigs = ErrDigs + MachData.FracDigs;

	if (LossDigs <= 0)
	{
	    LossDigs = 0;
	}
	printf("Estimated loss of base %d significant digits "
		" is %.2Lf\n", MachData.Radix, LossDigs);

	MeanSqrErr = xtold(xsqrt(XErrSqr)) / (LDBL)NumCpr;
	ErrDigs = xtold(xlog(MeanSqrErr) /
		  xlog(MachData.Radix));

	printf("The root-mean-square relative error was "
		"%.10LG = %d ^ %.2Lf\n",
		MeanSqrErr, MachData.Radix, ErrDigs);

	LossDigs = ErrDigs + MachData.FracDigs;

	if (LossDigs <= 0)
	{
	    LossDigs = 0;
	}
	printf("Estimated loss of base %d significant digits "
		" is %.2Lf\n", MachData.Radix, LossDigs);
	printf("\n");
    }
    printf("\n");
}
