/* ======== */
/* xvasin.h */
/* ======== */
// After Cody & Waite and Plauger
#include "xverfun.h"
// -----------------------
// asin(x) versus xasin(x)
// -----------------------
static
qfloat f1 (qfloat x, qfloat &pzz)
{
    TYPE    ASinArg;

    ASinArg = (TYPE)xtold(x);

    pzz = xasin(ASinArg);

    return NAME(asin)(ASinArg);
}
// -----------------------
// acos(x) versus xacos(x)
// -----------------------
static
qfloat f2 (qfloat x, qfloat &pzz)
{
    TYPE    ACosArg;

    ACosArg = (TYPE)xtold(x);

    pzz = xacos(ACosArg);

    return NAME(acos)(ACosArg);
}
// -----------------------------------------------------------------
// Main Program to Test asin/acos Function versus Extended asin/acos
// -----------------------------------------------------------------
static const TYPE PI = 3.141592653589793238462643383279502884L;

#define	MAK_STR(x)	STR_NAME(x)
#define	STR_NAME(x)	#x
#define	TEST_FUN_1	NAME(asin)
#define	TEST_FUN_2	NAME(acos)
#define	TEST_SIZE	1000
int
main()
{
    int		 k;
    TYPE	 RadixPow;
    TYPE	 ACosArg, ACosAns, ASinArg, ASinAns;
    char	 Label[128];
    const char  *FunStr1 = MAK_STR(TEST_FUN_1);
    const char  *FunStr2 = MAK_STR(TEST_FUN_2);
    MACHAR_STRU  MachData;

    printf("Test of %s(x) vs. xasin(x) & "
	           "%s(x) vs. xacos(x):\n",
	    FunStr1, FunStr2);

    MachData = GetMachar();

    printf("There are %d base %d significant digits\n\n",
	    MachData.FracDigs, MachData.Radix);
    sprintf(Label, "Test 1: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr1,
		TEST_SIZE, -0.125L, 0.125L);
    XVerFun(MachData, TEST_SIZE, -0.125L, 0.125L, &f1, Label);

    sprintf(Label, "Test 2: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr2,
		TEST_SIZE, -0.125L, 0.125L);
    XVerFun(MachData, TEST_SIZE, -0.125L, 0.125L, &f2, Label);

    sprintf(Label, "Test 3: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr1,
		TEST_SIZE, 0.75L, 1.00L);
    XVerFun(MachData, TEST_SIZE, 0.75L, 1.00L, &f1, Label);

    sprintf(Label, "Test 4: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr2,
		TEST_SIZE, 0.75L, 1.00L);
    XVerFun(MachData, TEST_SIZE, 0.75L, 1.00L, &f2, Label);

    sprintf(Label, "Test 5: %s(x) for %d values in "
		   "(%.10LG, %.10LG)", 	FunStr2,
		TEST_SIZE, -1.00L, -0.75L);
    XVerFun(MachData, TEST_SIZE, -1.00L, -0.75L, &f2, Label);

    printf("\nSPECIAL VALUES:\n\n");

    printf("\t%s(x) + %s(-x) for random values in "
	   "[0, 1)\n", FunStr1, FunStr1);

    for (k = 1; k <= 5; ++k)
    {
	ASinArg = -(TYPE) LDURand();
	ASinAns = NAME(asin) (ASinArg);
	ASinAns += NAME(asin) (-ASinArg);

	printf("\t\tx =%14.10Lf, %s(x) + %s(-x) = %.10LG\n",
	    (LDBL) ASinArg, FunStr1, FunStr1,
	    (LDBL) ASinAns);
    }

    RadixPow = (TYPE) 1;
    for (k = 1; k <= MachData.FracDigs; ++k)
	RadixPow *= (TYPE) MachData.Radix;

    ASinArg = (TYPE) (LDURand() / RadixPow);

    printf("\n\t%s(x) - x for Small x\n", FunStr1);
    for (k = 1; k <= 5; ++k)
    {
	ASinAns = NAME(asin)(ASinArg) - ASinArg;
	printf("\t\tx = %.10LE, %s(x) - x = %.20LG\n",
	    (LDBL) ASinArg, FunStr1,
	    (LDBL) ASinAns);

	ASinArg /= (TYPE) MachData.Radix;
    }
    printf("\n\tTesting underflow for "
	   "very small argument\n");
    RadixPow = (TYPE) 1;
    for (k = 1; k <= -3 * (MachData.MinExp / 4); ++k)
	RadixPow /= (TYPE) MachData.Radix;

    ASinAns = NAME(asin)(RadixPow);

    fflush(NULL);
    printf("\n\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) RadixPow, FunStr1,
	(LDBL) ASinAns);

    printf("\nBOUNDARY VALUES:\n");
    printf("\nThe following calls might "
	   "trigger error messages:\n");
    fflush(NULL);

    ASinArg = (TYPE)1.25;
    ASinAns = NAME(asin)(ASinArg);
    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) ASinArg, FunStr1,
	(LDBL) ASinAns);
    fflush(NULL);

    ACosArg = -(TYPE)1.25;
    ACosAns = NAME(acos)(ACosArg);
    fflush(NULL);
    printf("\tx = %.10LG, %s(x) = %.10LG\n",
	(LDBL) ACosArg, FunStr2,
	(LDBL) ACosAns);

    return (0);
}
