LISTING 2

#ifndef SPDBAND_H
#define SPDBAND_H

#include "bandstor.h"

template <class T> class SPDBandMatrix : public bandStorage<T>
{
private:

public:
    SPDBandMatrix() {}
    SPDBandMatrix(const SPDBandMatrix&);
    SPDBandMatrix(const int k) : bandStorage<T>(k) {}
    vector<T>& diagonal(const int);
    void setDiag(const int, const T);
    inline int& bandWidth(void) {return lowerBandWidth();}
};

template <class T>
    SPDBandMatrix<T>::SPDBandMatrix(const SPDBandMatrix<T>& m)
{
    bandStorage<T>::bandStorage(*this);
}

template <class T> vector<T>& SPDBandMatrix<T>::diagonal(const int i)
{
    return bandStorage<T>::diag(int(-fabs(i)));
}

template <class T> void SPDBandMatrix<T>::setDiag(const int i, const T s)
{
    vector<T> diag(order()-i);
    diag = s;
    bandStorage<T>::diag(int(-fabs(i))) = diag;
}

#endif
