//////////////////////////////////////////////
//        E-Systems, Montek Division
//////////////////////////////////////////////
// Rev 1.2   03 Apr 1995 11:03:32   DWENDEL
//////////////////////////////////////////////
#ifndef timer_h
# define timer_h

#ifndef boolean
#define boolean int
#define true (1)
#define false (0)
#endif

const int max_timers = 10;

typedef int TIMER_HANDLE;

class TIMER {
  public:
    int executive_tic(void);
    TIMER_HANDLE open_timer(float seconds);
    boolean expired(const TIMER_HANDLE &handle);
    float time_left(const TIMER_HANDLE &handle);
    void close_timer(TIMER_HANDLE &handle);
    TIMER(void);
    ~TIMER(void){}
  private:
    const int count_mod;
    boolean timer_used[max_timers];
    boolean timer_expired[max_timers];
    int expire_time[max_timers];
    int time_count;
    long last_bios_time;
    TIMER_HANDLE search_next_handle_start;
};

#endif
