Listing 4

/*
Final version with range
checking and macros
*/

int ByteOverflow()
  {
  return( 0 ) ;
  }

template< unsigned long N > struct 
  InRangeBinByte
  {
  enum { value = (N <= 11111111L) } ;
  } ;

template< unsigned long N > struct BinByte
  {
  enum { value = InRangeBinByte< N > :: value ? 
          BinDigitOrError< (N % 10) > :: value + 
          2 * BinByte< N / 10 > :: value :
          ByteOverflow() } ;
  } ;

struct BinByte< 0 >
  {
  enum { value = 0 } ;
  } ;

#define BIN_BYTE( N ) \
  ((unsigned int)BinByte< (N) > :: value)
#define BIN_WORD_LE( N, M ) \
  ( 256 * BIN_BYTE( N ) + BIN_BYTE( M ) )
