class AnalogInput
{
    friend MasterRun;
    friend Configure;
    const Address inputA_, inputB_;
    Bool safe_;
    Time lastReset_;
    Auditor *auditor_;
    Signal scaleFactor_;

    void reset() {
    const Time time = mtime();
    if( time > lastReset_ + Global::resetHoldoff )
        safe_ = Global::true;
    lastReset_ = time;
    }
    void scaleFactor( const Signal& scale ){ scaleFactor_ = scale; }

public:
    Bool ready()          const { return safe_; }
    Signal scaleFactor()  const { return scaleFactor_; }
    Signal offsetWindow() const { return Global::voltWin * 2.; }
    Signal errorWindow()  const { return Global::over 
                                  - Global::under; }
    Signal level() {
    if( ! safe_ ) {
        auditor_->fault();
        return Global::analogError;
    }

    const Signal aLevel = readAnalog( inputA_ ),
        bLevel = readAnalog( inputB_ ) * scaleFactor_,
        averageLevel = ( aLevel + bLevel ) / 2.,
        aAbsLevel = abs( aLevel ),
        bAbsLevel = abs( bLevel );
    auditor_->refresh();

    if( aAbsLevel < Global::voltWin && 
        bAbsLevel < Global::voltWin )
        return averageLevel;

    if( sign( aLevel ) == sign( bLevel ) &&
        aAbsLevel < Global::over * bAbsLevel + Global::voltWin &&
        aAbsLevel > Global::under * bAbsLevel - Global::voltWin )
        return averageLevel;

    auditor_->fault();
    safe_ = Global::false;
    return Global::analogError;
    }
};
