class DigitalInput
{
    friend MasterRun;
    const Address inputA_, inputB_;
    Bool safe_;
    Time lastReset_;
    Auditor *auditor_;

    void reset() {
    const Time time = mtime();
    if( time > lastReset_ + Global::resetHoldoff )
        safe_ = Global::true;
    lastReset_ = time;
    }

public:
    Bool state() {
    if( ! safe_ ) {
        auditor_->fault();
        return Global::digitalError;
    }

    const Bool aState = readDigital( inputA_ ),
        bState = ! readDigital( inputB_ );
    auditor_->refresh();

    if( aState == bState )
        return aState;

    auditor_->fault();
    safe_ = Global::false;
    return Global::digitalError;
    }
};
