// ****************************************************************************
//
// Module:  parser.h
// Author:  Dick Lam
//
// Purpose: C++ class header file for cgiParser
//
// Notes:  This is a base class. It handles the reading from an input stream
//         and subsequent decoding and parsing of CGI data. The result is
//         a list of cgiName and cgiValue strings.
//
// ****************************************************************************

#ifndef MODULE_cgiParserh
#define MODULE_cgiParserh

#include <iostream.h>
#include <cgi/defs.h>

// class declaration
class cgiParser {

public:

   // constructor and destructor
   cgiParser(istream& input);
   virtual ~cgiParser();

   // returns the linked list
   cgiDataList& getList() const { return (cgiDataList&)data; }

   // reads, decodes, and parses the input stream of CGI data into a
   // linked list of name, value pairs (returns 0 if ok, 1 if error)
   virtual int parse();

protected:

   istream& in;         // stream for input
   cgiDataList data;    // list of cgiName, cgiValue pairs

   // erases all entries in the data list
   void clear();

   // gets a string from the input until the delimiter character is reached
   // and returns the decoded version (escaped characters removed and '+'
   // characters reverted to spaces)
   string getString(char delimiter = '\0');
   string decode(const string& encoded);
   char unescaped(char h1, char h2);

private:

   // private copy constructor and operator= (define these and make them
   // public to enable copy and assignment of the class)
   cgiParser(const cgiParser&);
   cgiParser& operator=(const cgiParser&);

};

#endif

// ****************************************************************************

// end of parser.h
