// parse.C

#include "tappl.h"
#include <cgi/process.h>
#include <cgi/defs.h>
#include <cgi/htmlhelp.h>

// class declaration
class ParseTest : public cgiProcessor {
public:
   virtual int process(cgiDataList& data);
};

// process - handle the data
int ParseTest::process(cgiDataList& data)
{
   // write the document type and HTML header
   cgiHTMLHelper html(cout);

   html.contentType();
   html.header("Parse Test");

   // write the name, value pairs of data
   cgiDataList::const_iterator i;

   for (i = data.begin(); i != data.end(); i++) {
      // the iterator points to the next name, value pair
      const pair<cgiName, cgiValue>& item = *i;

      // write out the name, value pair
      cout << "(" << item.first.c_str()
           << ", " << item.second.c_str()
           << ")" << endl;
   }

   // write the trailer and exit
   html.trailer();

   return 0;
}

// main program
int main()

{
   // instantiate and run the CGI application
   cgiTApplication<ParseTest> app;
   app.run();

   return 0;
}
