// ****************************************************************************
//
// Module:  environ.C
// Author:  Dick Lam
//
// Purpose: C++ class source file for cgiEnvironment
//
// Notes:  This is a base class. It allows access to environment variables
//         and has methods to query how data is being sent, whether the
//         browser accepts images, etc.
//
// ****************************************************************************

#define OS_OMIT_MIN_MAX

#include <stdlib.h>
#include <string.h>
#include <cgi/environ.h>

// ****************************************************************************

// cgiEnvironment - constructor

cgiEnvironment::cgiEnvironment()

{
   // init instance variables
}

// ----------------------------------------------------------------------------

// ~cgiEnvironment - destructor

cgiEnvironment::~cgiEnvironment()

{
}

// ----------------------------------------------------------------------------

// source of the data (GET or POST)

cgiDataMethod cgiEnvironment::source() const

{
   // get the environment string
   char *method = getenv("REQUEST_METHOD");
   if (!method)
      return cgiunknown;

   // test and return the data method
   if (strcmp(method, "GET") == 0)
      return cgiget;
   else if (strcmp(method, "POST") == 0)
      return cgipost;
   else
      return cgiunknown;
}

// ----------------------------------------------------------------------------

// can browser accept images

bool cgiEnvironment::acceptsImages() const

{
   // get the environment string
   char *accept = getenv("HTTP_ACCEPT");
   if (!accept)
      return cgiunknown;

   // see if the work 'image' is somewhere in the string
   if (strstr(accept, "image") == 0)
      return false;
   else
      return true;
}

// ----------------------------------------------------------------------------

// getFormInput - returns the encoded form input

string cgiEnvironment::getFormInput() const

{
   // check data source
   if (source() != cgiget)
      return string("");

   // get the environment string
   char *query = getenv("QUERY_STRING");
   if (!query)
      return string("");

   return string(query);
}

// ----------------------------------------------------------------------------

// getdataLength - returns the length of the input data stream

int cgiEnvironment::getDataLength() const

{
   // check data source
   if (source() != cgipost)
      return 0;

   // get the environment string
   char *lenstr = getenv("CONTENT_LENGTH");
   if (!lenstr)
      return 0;

   return atoi(lenstr);
}

// ****************************************************************************

// end of environ.C
