// ****************************************************************************
//
// Module:  process.h
// Author:  Dick Lam
//
// Purpose: C++ class header file for cgiProcessor
//
// Notes:  This is an abstract base class. It provides a default processing
//         action and a pure virtual function that a user-derived class
//         defines for processing CGI data.
//
// ****************************************************************************

#ifndef MODULE_cgiProcessorh
#define MODULE_cgiProcessorh

#include <cgi/defs.h>

// class declaration
class cgiProcessor {

public:

   // constructor and destructor
   cgiProcessor();
   virtual ~cgiProcessor();

   // does the work for the application using the input list of
   // name, value pairs (returns 0 if ok, 1 if error)
   virtual int process(cgiDataList& data) = 0;

   // default process when an error prevents the application from continuing
   static void defprocess();

protected:

   // helper methods that can be invoked by derived classes to query
   // the list of name, value pairs

   // returns true if data contains name as a key field, false otherwise
   bool contains(cgiDataList& data, const cgiName& name) const;

   // returns the value corresponding to a name
   cgiValue get(cgiDataList& data, const cgiName& name) const;

private:

   // private copy constructor and operator= (define these and make them
   // public to enable copy and assignment of the class)
   cgiProcessor(const cgiProcessor&);
   cgiProcessor& operator=(const cgiProcessor&);

};

#endif

// ****************************************************************************

// end of process.h
