// ****************************************************************************
//
// Module:  process.C
// Author:  Dick Lam
//
// Purpose: C++ class source file for cgiProcessor
//
// Notes:  This is an abstract base class. It provides a default processing
//         action and a pure virtual function that a user-derived class
//         defines for processing CGI data.
//
// ****************************************************************************

#include <cgi/process.h>

// ****************************************************************************

// cgiProcessor - constructor

cgiProcessor::cgiProcessor()

{
   // init instance variables
}

// ----------------------------------------------------------------------------

// ~cgiProcessor - destructor

cgiProcessor::~cgiProcessor()

{
}

// ----------------------------------------------------------------------------

// defprocess - called when an error prevents the application from continuing

void cgiProcessor::defprocess()

{
   cout << "HTTP/1.0 204 No response\r\n"
        << "Content-type: text/html\r\n\r\n";
}

// ----------------------------------------------------------------------------

// contains - checks if name is contained in the data list

bool cgiProcessor::contains(cgiDataList& data, const cgiName& name) const

{
   cgiDataList::const_iterator i = data.find(name);
   if ( i == data.end() )
      return false;

   return true;
}

// ----------------------------------------------------------------------------

// get - returns the value corresponding to the input name

cgiValue cgiProcessor::get(cgiDataList& data, const cgiName& name) const

{
   cgiDataList::const_iterator i = data.find(name);
   if ( i == data.end() )
      return cgiValue("");

   const pair<cgiName, cgiValue>& item = *i;
   return item.second;
}

// ****************************************************************************

// end of process.C
