// ****************************************************************************
//
// Module:  environ.h
// Author:  Dick Lam
//
// Purpose: C++ class header file for cgiEnvironment
//
// Notes:  This is a base class. It allows access to environment variables
//         and has methods to query how data is being sent, whether the
//         browser accepts images, etc.
//
// ****************************************************************************

#ifndef MODULE_cgiEnvironmenth
#define MODULE_cgiEnvironmenth

#include <stl.h>
#include <ostring.h>

// CGI data sources
enum cgiDataMethod { cgiunknown = 0,
                     cgiget = 1,
                     cgipost = 2
};

// class declaration
class cgiEnvironment {

public:

   // constructor and destructor
   cgiEnvironment();
   virtual ~cgiEnvironment();

   // source of the data (GET or POST)
   cgiDataMethod source() const;

   // determines if browser accept images
   bool acceptsImages() const;

   // for data source cgiget, the encoded form input is returned (if the data
   // source is cgiunknown or cgipost, a zero-length string is returned)
   string getFormInput() const;

   // for data source cgipost, the length of the input data stream to be
   // read from stdin is returned (0 is returned for cgiunknown or cgipost)
   int getDataLength() const;

protected:

private:

   // private copy constructor and operator= (define these and make them
   // public to enable copy and assignment of the class)
   cgiEnvironment(const cgiEnvironment&);
   cgiEnvironment& operator=(const cgiEnvironment&);

};

#endif

// ****************************************************************************

// end of environ.h
