// Example of Printing using GDI Pass-Through
#include <stdio.h>
#include <windows.h>
#include <assert.h>

//Max 20 printers may be defined
#define MAX_PRINTERS 20
#define MAX_PRINTER_NAME 100

//Array to store printer names
char PrinterNames[MAX_PRINTERS][MAX_PRINTER_NAME];
int NumPrinters=0;


void FindPrinters(void)
{
// Cycle though the list of available printers.
// Store the printer names in PrinterNames[][].

BYTE *pbuf;
DWORD dwSize, dwPrinters;

// Find out how much bytes is needed to
// hold PRINTER_INFO_5 array
EnumPrinters(PRINTER_ENUM_LOCAL,NULL,
	5, NULL,0,&dwSize, &dwPrinters);

pbuf = new BYTE[dwSize];

//Read in the printer array
EnumPrinters(PRINTER_ENUM_LOCAL,
NULL,5,pbuf,dwSize,
	&dwSize, &dwPrinters);

printf("Available Printers:\n");
if (dwPrinters != 0) {
	PRINTER_INFO_5 * pPrnInfo =
   	(PRINTER_INFO_5 *) pbuf;
   for (NumPrinters=0; NumPrinters < dwPrinters;
   	NumPrinters++,pPrnInfo++) {
      strcpy(&(PrinterNames[NumPrinters][0]),
      		 pPrnInfo->pPrinterName);
      printf("%d. %s\n",NumPrinters,
             pPrnInfo->pPrinterName);
      } // For       
	} // if
delete[] pbuf;
}

void main(void)
{
int Pindex;
DWORD Count;  // Count of bytes sent to printer
DOC_INFO_1 DocAttrib;
HANDLE hPrinter;

FindPrinters();

printf("Select a printer from 0 through %d:",
   NumPrinters-1);
scanf( "%d",&Pindex);

assert(OpenPrinter(PrinterNames[Pindex],
                     &hPrinter,NULL) == TRUE);
DocAttrib.pDocName = "Dave's Document";
DocAttrib.pOutputFile=NULL;

// Very Important! Must be "RAW" or else
// StarDocPrinter() will return
// Invalid Datatype!!
DocAttrib.pDatatype= "RAW";

// Specify DOC_INFO_1 data structure
assert(StartDocPrinter(hPrinter,1,
      (LPBYTE) &DocAttrib) != 0);

// Start of "Page"
assert(StartPagePrinter(hPrinter) == TRUE);
//Print page 1
WritePrinter(hPrinter,"Hello, Page1\r\n\f",
				 16,&Count);
//Print page 2
WritePrinter(hPrinter,"Hello, Page2\r\n\f",
				 16,&Count);
EndPagePrinter(hPrinter);
//End of "Page"

EndDocPrinter(hPrinter);
ClosePrinter(hPrinter);
}
