;! " Transformer (inclined sides) "
;? " Scale "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Required scenery density to show on (1-4) "=SML_Comp
; by Alessandro Antonini


MACRO _Transfo2

Local ObjEnd, Pcall1, Scall1, Dwg, ObjReturn

Area( SML_Lat, SML_Lon, 16 km, ObjEnd )
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    GoTo( ObjEnd )

Pcall1:
    Perspective

Scall1:
    _CondRefPoint( 0x77, ObjReturn, 3000, 48, 0, 1 m, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale)/100) * 10
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 1, 16 )
    Point(    -35,     0,   -45 ) ;1
    Point(    -35,     0,   -15 ) ;2
    Point(    -35,     0,    15 ) ;3
    Point(    -35,     0,    45 ) ;4
    Point(     35,     0,    45 ) ;5
    Point(     35,     0,    15 ) ;6
    Point(     35,     0,   -15 ) ;7
    Point(     35,     0,   -45 ) ;8
    Point(    -20,    40,   -45 ) ;9
    Point(    -20,    40,   -15 ) ;10
    Point(    -20,    40,    15 ) ;11
    Point(    -20,    40,    45 ) ;12
    Point(     15,    40,    45 ) ;13
    Point(     15,    40,    15 ) ;14
    Point(     15,    40,   -15 ) ;15
    Point(     15,    40,   -45 ) ;16

    SurfaceColor ( Red )
        Polygon_4(  1,  2, 10,  9 )
        Polygon_4(  3,  4, 12, 11 )
        Polygon_4(  4,  5, 13, 12 )
        Polygon_4(  5,  6, 14, 13 )
        Polygon_4(  7,  8, 16, 15 )
        Polygon_4(  1,  9, 16,  8 )

    SurfaceColor ( White )
        Polygon_4(  2,  3, 11, 10 )
        Polygon_4( 10, 11, 14, 15 )
        Polygon_4(  6,  7, 15, 14 )

    SurfaceColor ( Red )
        Polygon_4( 11, 12, 13, 14 )
        Polygon_4(  9, 10, 15, 16 )
    Return

ObjEnd:
ENDMACRO
