;! " 18 SIDES :) shaded GAS TANK "
;? " Altitude "=SML_Altitude
;? " Scale "=SML_Scale

MACRO GasTank_1

Local ObjEnd, ObjR, Dwg, Pcall1, Scall1, Ntest, Dwg2


Area( SML_Lat, SML_Lon, 10 km, ObjEnd ) 
	PerspectiveCall( Pcall1 )
	GoTo( ObjEnd )

Pcall1:
	Perspective
    _CondRefPoint(0x77, ObjR, 8000, 100, 0, 1, SML_Lat, SML_Lon, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100

	Rotate( Dwg,  0,  0,   0d ) ;1
	Rotate( Dwg,  0,  0,  20d ) ;2
	Rotate( Dwg,  0,  0,  40d ) ;3
	Rotate( Dwg,  0,  0,  60d ) ;4
	Rotate( Dwg,  0,  0,  80d ) ;5
	Rotate( Dwg,  0,  0, 100d ) ;6
	Rotate( Dwg,  0,  0, 120d ) ;7
	Rotate( Dwg,  0,  0, 140d ) ;8
	Rotate( Dwg,  0,  0, 160d ) ;9
	Rotate( Dwg,  0,  0, 180d ) ;10
	Rotate( Dwg,  0,  0, 200d ) ;11
	Rotate( Dwg,  0,  0, 220d ) ;12
	Rotate( Dwg,  0,  0, 240d ) ;13
	Rotate( Dwg,  0,  0, 260d ) ;14
	Rotate( Dwg,  0,  0, 280d ) ;15
	Rotate( Dwg,  0,  0, 300d ) ;16
	Rotate( Dwg,  0,  0, 320d ) ;17
	Rotate( Dwg,  0,  0, 340d ) ;18

ObjR:
	Return
    
Dwg:
	PointsListVect( 0, 10 )
	PointVect( 		0, 	90,   0 ) ;0
	PointVect(	  -18, 	 0,	100 ) ;1
	PointVect(	   18,   0, 100 ) ;2
	PointVect(	   18,  45, 100 ) ;3
	PointVect(	  -18,  45, 100 ) ;4
	PointVect(	   18,  55, 100 ) ;5
	PointVect(	  -18,  55, 100 ) ;6
	PointVect(	  -18,  75, 100 ) ;7
	PointVect(	   18,  75, 100 ) ;8
	PointVect(	    0,  96,   0 ) ;9

	GradColor( White )
	GradPolygon_4( 1, 2, 3, 4 )       ; Lower  band
	GradColor( Red )
	GradPolygon_4( 3, 5, 6, 4 )       ; Middle  band
	GradColor( White )
	GradPolygon_4( 5, 8, 7, 6 )       ; Upper  band
	GradColor( Grey )
	GradPolygon_3(  8,  0,  7 )       ; Roof 

    GoIfVector( ObjR,  8, 0, 7 )
	LineColor( LightGrey )
	MoveTo( 0, 90, 0 )
	LineTo( 0, 96, 0 )

    GoIfNot( ObjR, Day_time, 0xFFFE )
	LineColor( NightRed )
	Dot( 0, 96, 0 )
	Return


ObjEnd:
ENDMACRO
