;! " Radar (Airport type 1) "
;? " Scale: "=SML_Scale
;? " Altitude: "=SML_Alt
;? " Required scenery density to show on (1-4): "=SML_Comp
; converted by Alessandro Antonini (with permission)

MACRO _Radar1

Local ObjEnd, Pcall, Scall, Dwg, ObjReturn, Move1, Move2, Move3, Move4, Move5,
      Move6, Move6, Move7, Move8, Move9, Move10, Move11, Move12, Move13,
      Move14, Move15, Move16, radar, Ntest, grille, tete, phare

Area(  SML_Lat, SML_Lon, 18 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, Sml_Comp, 4 )
    PerspectiveCall( Pcall  )
    ShadowCall( Scall  )
    Jump( ObjEnd )

Pcall:
    Perspective

Scall:
    CondRefPoint( ObjReturn, 2831, 18, 0, 0.1, SML_Lat, SML_Lon, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (Pow(SML_Scale,2))/100
    Rotate( Dwg, 0, 0, 0 ) 
    Return

Dwg:
    PointsList(  0, 7 )
    Point(       1,    0,    0  )
    Point(       0,    0,   -1  )      
    Point(      -1,    0,    0  )      
    Point(       0,    0,    1  )
    Point(       0,    4,    0  )       
    Point(       0,    8,    0  )       
    Point(       0,   10,    0  )

    SurfaceColor( 0x03 )
    Polygon_3(  0,  4,  1 )
        
    SurfaceColor( 0x04 )
    Polygon_3(  1,  4,  2 )
        
    SurfaceColor( 0x03 )
    Polygon_3(  2,  4,  3 )
        
    SurfaceColor( 0x04 )
    Polygon_3(  3,  4,  0 )
        
    LineColor( 0x00 )
    MoveToPoint( 5 )
    LineToPoint( 6 )
        
    GoIfNot( Move1,  0x282, 0001 )
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   000.00,  0  )
    Return

Move1:
    GoIfNot( Move2,  0x282, 0003 ) 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   22.50,  0  )

    LineColor( 0x10 )
    Call( phare )
    Return

Move2:
 
    GoIfNot( Move3,  0x282, 0006 )
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   45.00,  0  )
    Return

Move3:
    GoIfNot( Move4,  0x282, 000C )          ;1100
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   67.50,  0  )
    Return

Move4:        
    GoIfNot( Move5,  0x282, 0018 )        ; 11000
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   90.00,  0  )
    Return

Move5:
    GoIfNot( Move6,  0x282, 0030 )         ;110000
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   112.50,  0  )

    LineColor( 0x04 )
    Call( phare )
    Return

Move6:
    GoIfNot( Move7,  0x282, 0060 )         ;1100000
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   135.00,  0  )
    Return

Move7:
    GoIfNot( Move8,  0x282, 0x00C0 )       ;11000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   157.50,  0  )
    Return

Move8:
    GoIfNot( Move9,  0x282, 0180 )       ;110000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   180.00,  0  )
    Return

Move9:
    GoIfNot( Move10,  0x282, 0300 )       ;1100000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   202.50,  0  )
    LineColor( 0x0F )
    Call( phare )
    Return

Move10:
    GoIfNot( Move11,  0x282, 0600 )       ;11000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   225.00,  0  )
    Return

Move11:
    GoIfNot( Move12,  0x282, 0x0C00 )       ;110000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   247.50,  0  )
    Return

Move12:
    GoIfNot( Move13,  0x282, 1800 )       ;1100000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   270.00,  0  )
    Return

Move13:
    GoIfNot( Move14,  0x282, 3000 )       ;11000000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   292.50,  0  )
    LineColor( 0x04 )
    Call( phare )
    Return

Move14:
    GoIfNot( Move15,  0x282, 6000 )       ;110000000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0 ,  315.00,  0  )
    Return

Move15:
    GoIfNot( Move16,  0x282, 0xC000 )       ;1100000000000000 
    IndirectRotate( radar,  0,  0,  0,    0,  0,    0,  0,   337.50,  0  )
    Return

Move16:
    Return


radar:
    Pointslist(  0, 18 )
    Point(       4,   4,  -1 )    
    Point(       4,   4,   0 )     
    Point(       4,   5,   1 )     
    Point(       4,   7,   1 )
    Point(       4,   8,   0 )    
    Point(       4,   8,  -1 )
    Point(      -4,   4,  -1 )   
    Point(      -4,   4,   0 )    
    Point(      -4,   5,   1 )    
    Point(      -4,   7,   1 )
    Point(      -4,   8,   0 )   
    Point(      -4,   8,  -1 )
    Point(       2,   4,  -1 )    
    Point(       0,   5,  -5 )
    Point(      -2,   4,  -1 )    
    Point(       0,   6,  -5 )
    Point(       1,   4,  -1 )
    Point(      -1,   4,  -1 )

    GoIfVector( Ntest, 8, 9, 3 )
    Call( grille )
    Call( tete )
    Return        

Ntest:
    Call( tete )
    Call( grille )
    Return

grille:
    Texture(  "airpt003", "oav" )
    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   2,  73,  143 )      
      TexturePt(   3,  73,  112 )
      TexturePt(   9,   3,  112 )
      TexturePt(   8,   3,  143 )
        
    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   8,   3,  143 )
      TexturePt(   9,   3,  112 )
      TexturePt(   3,  73,  112 )
      TexturePt(   2,  73,  143 )      
        
    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   0,  73,  143 )
      TexturePt(   1,  73,  112 )
      TexturePt(   7,   3,  112 )
      TexturePt(   6,   3,  143 )      

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   6,   3,  143 )      
      TexturePt(   7,   3,  112 )
      TexturePt(   1,  73,  112 )
      TexturePt(   0,  73,  143 )

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   1,  73,  143 )
      TexturePt(   2,  73,  112 )
      TexturePt(   8,   3,  112 )
      TexturePt(   7,   3,  143 )      

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   7,   3,  143 )      
      TexturePt(   8,   3,  112 )
      TexturePt(   2,  73,  112 )
      TexturePt(   1,  73,  143 )
        
    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   3,  73,  143 )
      TexturePt(   4,  73,  112 )
      TexturePt(  10,   3,  112 )
      TexturePt(   9,   3,  143 )      

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   9,   3,  143 )      
      TexturePt(  10,   3,  112 )
      TexturePt(   4,  73,  112 )
      TexturePt(   3,  73,  143 )

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(   4,  73,  143 )
      TexturePt(   5,  73,  112 )
      TexturePt(  11,   3,  112 )
      TexturePt(  10,   3,  143 )      

    AdjustTexture      
    TexturePolygon( 4 )
      TexturePt(  10,   3,  143 )      
      TexturePt(  11,   3,  112 )
      TexturePt(   5,  73,  112 )
      TexturePt(   4,  73,  143 )
    Return

tete:
    SurfaceColor( 0x03 )        
    Polygon_3( 12, 13, 16 )
    Polygon_3( 16, 13, 12 )
    Polygon_3( 17, 13, 14 )
    Polygon_3( 14, 13, 17 )
    LineColor( 0x05 )
    MoveToPoint( 13 )
    LineToPoint( 15 )
    Return

phare:
    Dot( 0,  10,  0 )
    Return

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
