;! " Rounded roof hangar with fixed door"
;? " Scale: "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Walls Color: "=SML_Wall
;? " Roof  Color: "=SML_Roof
;? " Door  Color: "=SML_Door
;? " Scenery density required to show on (1-4): "=SML_Comp
; by Alessandro Antonini



MACRO _Hangar2f

Local ObjEnd, PCall, Scall, Dwg, ObjReturn, Ntest, Inner, Outer, Door, Nlite,
      Drcolor

    Drcolor = 0x01 ; default
    If ( SML_Door == 0 )
        Drcolor = 0x00
    EndIf
    If ( SML_Roof == 1 )
        Drcolor = 0x01
    EndIf
    If ( SML_Door == 2 )
        Drcolor = 0x02
    EndIf
    If ( SML_Door == 3 )
        Drcolor = 0x03
    EndIf
    If ( SML_Door == 4 )
        Drcolor = 0x04
    EndIf
    If ( SML_Door == 5 )
        Drcolor = 0x05
    EndIf
    If ( SML_Door == 6 )
        Drcolor = 0x06
    EndIf
    If ( SML_Door == 7 )
        Drcolor = 0x07
    EndIf
    If ( SML_Door == 8 )
        Drcolor = 0x08
    EndIf
    If ( SML_Door == 9 )
        Drcolor = 0x09
    EndIf


      
      
Area( SML_Lat, SML_Lon, 20 km, ObjEnd ) 
     GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
     PerspectiveCall( PCall )
     ShadowCall( Scall )
     Jump( ObjEnd )

PCall:
    Perspective

Scall:    
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (Pow(SML_Scale,2))/100
    Rotate( Dwg,  0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList(  0, 36 )
        Point( -30,    0,   -30   )      ; 0
        Point( -30,    6,   -30   )      ; 1
        Point(  30,    6,   -30   )      ; 2
        Point(  30,    0,   -30   )      ; 3
        Point(  25,    0,   -30   )      ; 4
        Point(  25,   15,   -30   )      ; 5
        Point( -25,   15,   -30   )      ; 6
        Point( -25,    0,   -30   )      ; 7
        Point( -30,    0,    30   )      ; 8
        Point( -30,    6,    30   )      ; 9
        Point(  30,    6,    30   )      ; 10
        Point(  30,    0,    30   )      ; 11
        Point( -28,   16,   -30   )      ; 12
        Point( -28,   16,    30   )      ; 13
        Point( -22,   25,   -30   )      ; 14
        Point( -22,   25,    30   )      ; 15
        Point( -15,   31,   -30   )      ; 16
        Point( -15,   31,    30   )      ; 17
        Point(  -5,   35,   -30   )      ; 18
        Point(  -5,   35,    30   )      ; 19
        Point(   5,   35,   -30   )      ; 20
        Point(   5,   35,    30   )      ; 21
        Point(  14,   31,   -30   )      ; 22
        Point(  14,   31,    30   )      ; 23
        Point(  22,   25,   -30   )      ; 24
        Point(  22,   25,    30   )      ; 25
        Point(  28,   16,   -30   )      ; 26
        Point(  28,   16,    30   )      ; 27

        Point(  25,    3,   -30   )      ; 28
        Point( -25,    3,   -30   )      ; 29

        Point(  25,    6,   -30   )      ; 30
        Point( -25,    6,   -30   )      ; 31

        Point(  25,    9,   -30   )      ; 32
        Point( -25,    9,   -30   )      ; 33

        Point(  25,   12,   -30   )      ; 34
        Point( -25,   12,   -30   )      ; 35

    Call( Inner )
    Call( Outer )
    Call( Door  )
    Call( Nlite )
    Return    

Inner:
    SurfaceColor( 0x02 )
    Concave
    ; Inside North wall
        Polygon_16( 0, 7, 6, 5, 4, 3, 2, 26, 24, 22, 20, 18, 16, 14, 12, 1 )  
    ; Inside South wall
        Polygon_12( 8,  9, 13, 15, 17, 19, 21, 23, 25, 27, 10, 11 )
        Polygon_4(  1,  9,  8,  0 )        ; Inside East wall 
        Polygon_4( 11, 10,  2,  3 )        ; Inside west wall
        Polygon_4(  9,  1, 12, 13 )        ; Inside roof
        Polygon_4( 13, 12, 14, 15 )        ; Inside roof
        Polygon_4( 15, 14, 16, 17 )        ; Inside roof
        Polygon_4( 17, 16, 18, 19 )        ; Inside roof
        Polygon_4( 19, 18, 20, 21 )        ; Inside roof
        Polygon_4( 21, 20, 22, 23 )        ; Inside roof
        Polygon_4( 23, 22, 24, 25 )        ; Inside roof
        Polygon_4( 25, 24, 26, 27 )        ; Inside roof
        Polygon_4( 27, 26,  2, 10 )        ; Inside roof
        Polygon_4(  0,  8, 11,  3 )        ; Hangar floor
    Return

    
Outer:
    If ( SML_Wall == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If ( SML_Wall == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If ( SML_Wall == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If ( SML_Wall == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If ( SML_Wall == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If ( SML_Wall == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If ( SML_Wall == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If ( SML_Wall == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If ( SML_Wall == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If ( SML_Wall == 9 )
        SurfaceColor( 0x09 )
    EndIf
    Concave
    ; Outside North wall
        Polygon_16( 1, 12, 14, 16, 18, 20, 22, 24, 26, 2, 3, 4, 5, 6, 7, 0 )  
    ; Outside South wall
        Polygon_12(   11, 10, 27, 25, 23, 21, 19, 17, 15, 13, 9, 8 )        
        Polygon_4(  0,  8,  9,  1 )        ; Outside East wall 
        Polygon_4(  3,  2, 10, 11 )        ; Outside west wall


    If ( SML_Roof == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If ( SML_Roof == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If ( SML_Roof == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If ( SML_Roof == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If ( SML_Roof == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If ( SML_Roof == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If ( SML_Roof == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If ( SML_Roof == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If ( SML_Roof == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If ( SML_Roof == 9 )
        SurfaceColor( 0x09 )
    EndIf
        Polygon_4( 13, 12,  1,  9 )        ; Outside roof
        Polygon_4( 15, 14, 12, 13 )        ; Outside roof
        Polygon_4( 17, 16, 14, 15 )        ; Outside roof
        Polygon_4( 19, 18, 16, 17 )        ; Outside roof
        Polygon_4( 21, 20, 18, 19 )        ; Outside roof
        Polygon_4( 23, 22, 20, 21 )        ; Outside roof
        Polygon_4( 25, 24, 22, 23 )        ; Outside roof
        Polygon_4( 27, 26, 24, 25 )        ; Outside roof
        Polygon_4( 10,  2, 26, 27 )        ; Outside roof
    Return
    
Door:
    SurfaceColor( DrColor )
    Polygon_4(  7,  6,  5,  4 )             ; Door fully closed
    Return

Nlite:
    GoIfNot( Ntest, 0x28C, 6 )            ; Night lights
    LineColor( 0x15 )
    GoIfVector( Ntest, 6, 5, 4 )
        DottedLine(  25, 15,  -30,  -25, 15,  -30,    4 )
    Return

Ntest:
    Return

ObjEnd:
    ENDMACRO
