;! " Rectangular flat-roof hangar "
;? " Scale: "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Door Color: "=SML_Door
;? " Wall Color: "=SML_Wall
;? " Roof Color: "=SML_Roof
;? " Altitude: "=SML_Alt
;? " Scenery density required to show on (1-4): "=SML_Comp
; Converted by Alessandro Antonini (with permission )

MACRO Hang_1

    Local Pcall1, Scall1, Dwg, ObjReturn, ObjEnd, hangar, volet, lampes,
          ouvre1, ferme1, ouvre2, ferme2, ouvre3, ferme3, ouvre4, ferme4,
          ouvre5, ferme5, ouvre6, ferme6

    Area(  SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall1  )
    ShadowCall( Scall1  )
    Goto( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 0.5, SML_Alt )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale) / 100) * 5
    Rotate(  Dwg,  0, 0, SML_Heading  )
    Return

Dwg:
    PointsList( 0, 22 )
    Point(    80,      00,     -200  )  ;0
    Point(   -80,      00,     -200  )  ;1
    Point(   -80,      00,      200  )  ;2
    Point(    80,      00,      200  )  ;3
    Point(    80,     100,     -200  )  ;4
    Point(   -80,     100,     -200  )  ;5
    Point(   -80,     100,      200  )  ;6
    Point(    80,     100,      200  )  ;7
    Point(    80,      00,     -190  )  ;8
    Point(    80,      70,     -190  )  ;9
    Point(    80,      70,      190  )  ;10
    Point(    80,      00,      190  )  ;11
    Point(    80,      11,     -190  )  ;12
    Point(    80,      22,     -190  )  ;13
    Point(    80,      33,     -190  )  ;14
    Point(    80,      44,     -190  )  ;15
    Point(    80,      55,     -190  )  ;16
    Point(    80,      11,      190  )  ;17
    Point(    80,      22,      190  )  ;18
    Point(    80,      33,      190  )  ;19
    Point(    80,      44,      190  )  ;20
    Point(    80,      55,      190  )  ;21
    
    Call( hangar )
    Call( volet )
    Call( lampes )
    Return


hangar:
    SurfaceColor(  Grey  )
        Polygon_4( 0, 1, 2, 3  )   ;sol
        Polygon_4( 6, 5, 4, 7  )   ;plafond intrieur
        Polygon_4( 2, 1, 5, 6  )   ;mur fond intrieur
        Polygon_4( 4, 5, 1, 0  )   ;mur cot G intrieur
        Polygon_4( 3, 2, 6, 7  )   ;mur cot D intrieur
        Polygon_4( 7, 10, 11, 3 )
        Polygon_4( 7, 4, 9, 10 )
        Polygon_4( 4, 0, 8, 9 )
                 
    If (SML_Wall == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Wall == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Wall == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Wall == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Wall == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Wall == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Wall == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Wall == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Wall == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Wall == 9)
      SurfaceColor( SandLight )
    EndIf
				Polygon_4( 6, 5, 4, 7  )
        Polygon_4( 7, 6, 2, 3  )
        Polygon_4( 0, 1, 5, 4  )
        Polygon_4( 6, 5, 1, 2  )
    Concave
        Polygon_8( 9, 10, 11, 3, 7, 4, 0, 8 )


    If (SML_Roof == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Roof == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Roof == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Roof == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Roof == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Roof == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Roof == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Roof == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Roof == 9)
      SurfaceColor( SandLight )
    EndIf
        Polygon_4( 7, 4, 5, 6  )   ;sol
        Return



volet:


GoIfOutCube( ferme1, -110, 110,  0, 40,  -190, 190 )
Jump(  ouvre1  )

ferme1:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
  Polygon_4( 11, 8, 12, 17 )

ouvre1:
  GoIfOutCube( ferme2, -109, 109,  0, 40,  -190, 190 )
  Jump(  ouvre2  )

ferme2:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
  Polygon_4( 17, 12, 13, 18 )

ouvre2:
  GoIfOutCube( ferme3, -108, 108,  0, 40,  -190, 190 )
  Jump(  ouvre3  )

ferme3:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
  Polygon_4( 18, 13, 14, 19 )

ouvre3:
  GoIfOutCube( ferme4, -107, 107,  0, 40,  -190, 190 )
  Jump(  ouvre4  )

ferme4:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
  Polygon_4( 19, 14, 15, 20 )

ouvre4:
  GoIfOutCube( ferme5, -106, 106,  0, 40,  -190, 190 )
  Jump(  ouvre5  )

ferme5:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
  Polygon_4( 20, 15, 16, 21 )

ouvre5:
  GoIfOutCube( ferme6, -105, 105,  0, 40,  -190, 190 )
  Jump(  ouvre6  )

ferme6:
    If (SML_Door == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Roof == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Door == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Door == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Door == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Door == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Door == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Door == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Door == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Door == 9)
      SurfaceColor( SandLight )
    EndIf
    Polygon_4( 21, 16,  9, 10 )
    Return

ouvre6:
    Return

lampes:
    GoIfNot( ObjReturn, Day_time, 0xFFFE )
    GoIfVector( ObjReturn,  0, 4, 7 )
    LineColor ( NightYellow  )
    DottedLine( 80, 80, -190,  80, 
                80, 190,  6 )


ObjReturn:
    Return

ObjEnd:
ENDMACRO
