;! " Cypress tree "
;? " Scale "=SML_Scale
;? " Heading "=SML_Heading
;? " Altitude "=SML_Alt
;? " Required scenery density to show (1-4) "=SML_Comp 
;? " Is season change required (0-1) "=SML_Change

; Converted by Alessandro Antonini ( with permission )


MACRO _Bouleau

Local ObjEnd, Pcall1, ombre, Automne, Ete, Printemps, Faces, ObjReturn

Area( SML_Lat, SML_Lon,  9 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( ombre )
    Jump( ObjEnd )

Pcall1:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100

    PointsList( 0, 18 )
    Point(   -11,     0,    0 )  ;face
    Point(   -11,    98,    0 )
    Point(     5,    98,    0 )
    Point(     5,     0,    0 )

    Point(     0,     0,  -11 )  ;Profil
    Point(     0,    98,  -11 )
    Point(     0,    98,    5 )
    Point(     0,     0,    5 )

    Point(  -3,      0,    0  ); 8
    Point( -10,     14,    0  ); 9
    Point(   0,     98,    0  ); 10
    Point(   6,      9,    0  ); 11
    Point(   2,      0,    0  ); 12

    Point(   0,      0,   -3  ); 13
    Point(   0,     14,  -10  ); 14
    Point(   0,     98,    0  ); 15
    Point(   0,      9,    6  ); 16
    Point(   0,      0,    2  ); 17
  
    GoIfOut( Automne, 0x6F8, 0, 2 )
    GoIfOut( Ete, 0x6F8, 0, 1 )
    GoIfOut( Printemps, 0x6F8, 0, 0 )

    If( SML_Change == 1 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - north hemisphere
    EndIf

    If( SML_Change == 0 )
        Texture( "AIRPT004", "OAV" ) ; summer - south hemisphere
    EndIf
    Jump( Faces )

Printemps:
    If( SML_Change == 1 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn - south hemisphere
    EndIf
    Jump( Faces )

Ete:
    If( SML_Change == 1 )
        Texture( "AIRPT004", "OAV" ) ; summer - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - south hemisphere
    EndIf
    Jump( Faces )

Automne:
    If( SML_Change == 1 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn -north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - south hemisphere
    EndIf
    Jump( Faces )

Faces:
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,      2,    155 ) 
        TexturePt(  1,      2,    253 )
        TexturePt(  2,     18,    253 )
        TexturePt(  3,     18,    155 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,      2,    155 ) 
        TexturePt(  5,      2,    253 )
        TexturePt(  6,     18,    253 )
        TexturePt(  7,     18,    155 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,     18,    155 )
        TexturePt(  2,     18,    253 )
        TexturePt(  1,      2,    253 )
        TexturePt(  0,      2,    155 ) 
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,     18,    155 )
        TexturePt(  6,     18,    253 )
        TexturePt(  5,      2,    253 )
        TexturePt(  4,      2,    155 ) 
    TransparentOff
    Return

ombre:
    SurfaceColor( 0x18 ) 
    Polygon_5( 12, 11, 10,  9,  8 )
    Polygon_5( 17, 16, 15, 14, 13 )
    Polygon_5(  8,  9, 10, 11, 12 )
    Polygon_5( 13, 14, 15, 16, 17 )
    Return

ObjReturn:
    Return
ObjEnd:
ENDMACRO
