;! " Textured 'L' Hangar (semi-adjustable) "
;? " 1. Grey/LtGrey, 2. Blue/DkBlue, 3. Brown/LtBrown - Type: "=SML_Type
;? " Scale : "=SML_Scale
;? " Heading [HDG]: "=SML_Heading

; by Alessandro Antonini

MACRO _CusHang6

Local ObjEnd, ObjReturn, Pcall, Scall, Dwg, Outer, x41, y41, x42, y42, x43, 
			y43, x44, y44, x31, y31, x32, y32, x33, y33, x34, y34, x21, y21, x22,
      y22, x23, y23, x24, y24, x11, y11, x12, y12, x13, y13, x14, y14, Roof

; let's assume defaults
		x41 = 0
		y41 = 27
		x42 = 154
		y42 = 27
		x43 = 154
		y43 = 48
		x44 = 0
		y44 = 48

		x31 = 0
		y31 = 52
		x32 = 115
		y32 = 52
		x33 = 115
		y33 = 73
		x34 = 0
		y34 = 73

		x21 = 158
		y21 = 27
		x22 = 235
		y22 = 27
		x23 = 235
		y23 = 48
		x24 = 158
		y24 = 48

		x11 = 119
		y11 = 52
		x12 = 157
		y12 = 52
		x13 = 157
		y13 = 73
		x14 = 119
		y14 = 73

; else   
If ( SML_Type == 1 )
		x41 = 0
		y41 = 27

		x42 = 158
		y42 = 27

		x43 = 158
		y43 = 48

		x44 = 0
		y44 = 48

		x31 = 0
		y31 = 52
		x32 = 119
		y32 = 52
		x33 = 119
		y33 = 73
		x34 = 0
		y34 = 73

		x21 = 154
		y21 = 27
		x22 = 235
		y22 = 27
		x23 = 235
		y23 = 48
		x24 = 154
		y24 = 48


		x11 = 115
		y11 = 52
		x12 = 157
		y12 = 52
		x13 = 157
		y13 = 73
		x14 = 115
		y14 = 73
EndIf   

If ( SML_Type == 2 )
		x41 = 0
		y41 = 130
		x42 = 122
		y42 = 130
		x43 = 122
		y43 = 152
		x44 = 0
		y44 = 152

		x31 = 0
		y31 = 130
		x32 = 92
		y32 = 130
		x33 = 92
		y33 = 152
		x34 = 0
		y34 = 152

		x21 = 0
		y21 = 130
		x22 = 62
		y22 = 130
		x23 = 62
		y23 = 152
		x24 = 0
		y24 = 152

		x11 = 0
		y11 = 130
		x12 = 32
		y12 = 130
		x13 = 32
		y13 = 152
		x14 = 0
		y14 = 152
EndIf   

If ( SML_Type == 3 )
		x41 = 0
		y41 = 77
		x42 = 158
		y42 = 77
		x43 = 158
		y43 = 98
		x44 = 0
		y44 = 98

		x31 = 0
		y31 = 102
		x32 = 119
		y32 = 102
		x33 = 119
		y33 = 123
		x34 = 0
		y34 = 123

		x21 = 154
		y21 = 77
		x22 = 235
		y22 = 77
		x23 = 235
		y23 = 98
		x24 = 154
		y24 = 98

		x11 = 115
		y11 = 102
		x12 = 157
		y12 = 102
		x13 = 157
		y13 = 123
		x14 = 115
		y14 = 123
EndIf   

   


Area( SML_Lat, SML_Lon, 12 Km, ObjEnd )
		PerspectiveCall( Pcall )
		ShadowCall( Scall )
		Jump( ObjEnd )

Pcall:
		Perspective

Scall:
		ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
		Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
		Return

Dwg:
		PointsList( 1, 12 )
		Point(      0,      0,      0   ) ;1
		Point(    -68,      0,      0   ) ;2
		Point(    -68,      0,     32   ) ;3
		Point(     36,      0,     32   ) ;4
		Point(     36,      0,    -36   ) ;5
		Point(      0,      0,    -36   ) ;6

		Point(      0,     20,      0   ) ;7
		Point(    -68,     20,      0   ) ;8
		Point(    -68,     20,     32   ) ;9
		Point(     36,     20,     32   ) ;10
		Point(     36,     20,    -36   ) ;11
		Point(      0,     20,    -36   ) ;12
		Call( Outer )
		Call( Roof  )
		Return


Outer:
		SurfaceColor( 0x02 )
		Texture( "a-obj-2", "r8" )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt(  8, x31, y31 )
				TexturePt(  7, x32, y32 )
				TexturePt(  1, x33, y33 )
				TexturePt(  2, x34, y34 )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt(  7, x11, y11 )
				TexturePt( 12, x12, y12 )
				TexturePt(  6, x13, y13 )
				TexturePt(  1, x14, y14 )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt(  9, x21, y21 )
				TexturePt(  8, x22, y22 )
				TexturePt(  2, x23, y23 )
				TexturePt(  3, x24, y24 )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt( 10, x41, y41 )
				TexturePt(  9, x42, y42 )
				TexturePt(  3, x43, y43 )
				TexturePt(  4, x44, y44 )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt( 11, x31, y31 )
				TexturePt( 10, x32, y32 )
				TexturePt(  4, x33, y33 )
				TexturePt(  5, x34, y34 )
		AdjustTexture
		TexturePolygon( 4 )
				TexturePt( 12, x21, y21 )
				TexturePt( 11, x22, y22 )
				TexturePt(  5, x23, y23 )
				TexturePt(  6, x24, y24 )
		Return

Roof:
		If ( SML_Type == 1 )
				SurfaceColor( 0x03 )
		EndIf
		If ( SML_Type == 2 )
				SurfaceColor( 0x07 )
		EndIf
		If ( SML_Type == 3 )
				SurfaceColor( SandLight )
		EndIf
		
		Concave
				Polygon_6( 7, 8, 9, 10, 11, 12 )
		Return

ObjEnd:
		ENDMACRO
