;! "Textured Transparent Polygon (ctype1.r8)"
;? "Mts Width: "=SML_Width
;? "Mts Length: "=SML_Lenght
;? "Heading (): "=SML_Heading
; by Alessandro Antonini

MACRO Tex_Poly

; NOTE: SC can't pass values higher than 3 digits to macro. If your polygon
; is higher than 999 square meters, then you have to adjust SML_Width and
; SML_Heigth in the code or multiply all values in Pointslist by 10

    local ObjEnd, PCall, SCall, ObjReturn, Dwg

    Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
        Priority( PCall,  0x18 ) ; change priority as of your needs
        Jump(  ObjEnd  )
    
    PCall:
        ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
        Rotate( Dwg, 0, 0, SML_Heading )

   
    Dwg:		 
        PointsList( 1, 4 )
        Point( -(SML_Width * 5 ) ,  0 , (SML_Lenght * 5)    )
        Point( (SML_Width * 5 ) ,     0 , (SML_Lenght * 5)    )
        Point( (SML_Width * 5 ) ,     0 , -(SML_Lenght * 5) )
        Point( -(SML_Width * 5 ) ,  0 , -(SML_Lenght *5) )
     
;        Palette( "eur1" ) ; if you are not into europe1 comment this out
        SurfaceColor( Grey )
        Texture( "CTYPE1", "r8" )
        AdjustTexture
        TransparentOn
        TexturePolygon( 4 )
        TexturePt( 1, 0, 0 )
        TexturePt( 2, 255, 0 )
        TexturePt( 3, 255, 255 )
        TexturePt( 4, 0, 255 )
        TransparentOff
        Return

    ObjReturn:
        Return
     
     ObjEnd:
ENDMACRO