;! " A wallkeepers Crane "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Scenery density required to show on (1-4): "=SML_Comp
;? " Structure Color: "=SML_Struc
;? " Counter-Weight Color: "=SML_Wall
;? " Base Color: "=SML_Base

MACRO _Crane1

Local ObjEnd, Pcall, Scall, Dwg, Wallc, Basec, Strucc, TagPoly, scambio,
      colonna, braccio, incima, contrapp, gancio, infine, TagEnd, DayTime,
      sostegno

; assume default colors

    Wallc   = 0x01
    Strucc  = 0x02
    Basec   = 0x01

; else

    If ( SML_Wall == 0 )
        Wallc = 0x00                    
    EndIf
    If ( SML_Wall == 1 )
        Wallc = 0x01                    
    EndIf
    If ( SML_Wall == 2 )
        Wallc = 0x02                    
    EndIf
    If ( SML_Wall == 3 )
        Wallc = 0x03                    
    EndIf
    If ( SML_Wall == 4 )
        Wallc = 0x04                    
    EndIf
    If ( SML_Wall == 5 )
        Wallc = 0x05                    
    EndIf
    If ( SML_Wall == 6 )
        Wallc = 0x06                    
    EndIf
    If ( SML_Wall == 7 )
        Wallc = 0x07                    
    EndIf
    If ( SML_Wall == 8 )
        Wallc = 0x08                    
    EndIf
    If ( SML_Wall == 9 )
        Wallc = 0x09                    
    EndIf

    If ( SML_Struc == 0 )
        Strucc = 0x00                   
    EndIf
    If ( SML_Struc == 1 )
        Strucc = 0x01                   
    EndIf
    If ( SML_Struc == 2 )
        Strucc = 0x02                   
    EndIf
    If ( SML_Struc == 3 )
        Strucc = 0x03                   
    EndIf
    If ( SML_Struc == 4 )
        Strucc = 0x04                   
    EndIf
    If ( SML_Struc == 5 )
        Strucc = 0x05                   
    EndIf
    If ( SML_Struc == 6 )
        Strucc = 0x06                   
    EndIf
    If ( SML_Struc == 7 )
        Strucc = 0x07                   
    EndIf
    If ( SML_Struc == 8 )
        Strucc = 0x08                   
    EndIf
    If ( SML_Struc == 9 )
        Strucc = 0x09                   
    EndIf

    If ( SML_Base == 0 )
        Basec = 0x00                    
    EndIf
    If ( SML_Base == 1 )
        Basec = 0x01                    
    EndIf
    If ( SML_Base == 2 )
        Basec = 0x02                    
    EndIf
    If ( SML_Base == 3 )
        Basec = 0x03                    
    EndIf
    If ( SML_Base == 4 )
        Basec = 0x04                    
    EndIf
    If ( SML_Base == 5 )
        Basec = 0x05                    
    EndIf
    If ( SML_Base == 6 )
        Basec = 0x06                    
    EndIf
    If ( SML_Base == 7 )
        Basec = 0x07                    
    EndIf
    If ( SML_Base == 8 )
        Basec = 0x08                    
    EndIf
    If ( SML_Base == 9 )
        Basec = 0x09                    
    EndIf

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )
  
Pcall:
    Perspective  

Scall:
    CondRefPoint( TagPoly, 6851, 28, 0, 1, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = ( ( SML_Scale * 100 ) / ( SML_Scale * SML_Scale ) / 100 )     
    Rotate( Dwg, 0, 0, SML_Heading )

TagPoly:
    Return

Dwg:
    PointsList( 1, 20 )
    Point(      -8,     0,       8   )   ; 1
    Point(       8,     0,       8   )   ; 2
    Point(       8,     0,      -8   )   ; 3
    Point(      -8,     0,      -8   )   ; 4
                          
    Point(      -8,     2,       8   )   ; 5
    Point(       8,     2,       8   )   ; 6
    Point(       8,     2,      -8   )   ; 7
    Point(      -8,     2,      -8   )   ; 8

    Point(     -27,    51,       3   )   ; 9  - contrappeso
    Point(     -19,    51,       3   )   ; 10
    Point(     -19,    51,      -3   )   ; 11
    Point(     -27,    51,      -3   )   ; 12
                          
    Point(     -27,    56,       3   )   ; 13
    Point(     -19,    56,       3   )   ; 14
    Point(     -19,    56,      -3   )   ; 15
    Point(     -27,    56,      -3   )   ; 16

    Point(      55,    22,       0   )   ; 17            
    Point(      59,    22,       0   )   ; 18          
    Point(      59,    14,       0   )   ; 19             
    Point(      55,    14,       0   )   ; 20            

    Call( sostegno )
    GoIfVector( scambio, 10, 14, 15 )
    Call( colonna  )
    Call( braccio  )
    Call( incima )
    Call( contrapp )
    Call( gancio  )
    Return

scambio:
    Call( contrapp )
    Call( colonna  )
    Call( braccio  )
    Call( gancio  )
    Call( incima )
    Return



sostegno:                 ; base di sostegno
    SurfaceColor( Basec )
        Polygon_4( 5, 6, 7, 8 )
        Polygon_4( 1, 2, 6, 5 )
        Polygon_4( 2, 3, 7, 6 )
        Polygon_4( 3, 4, 8, 7 )
        Polygon_4( 4, 1, 5, 8 )
    Return


contrapp:                           ; contrappeso
    SurfaceColor( Wallc )
        Polygon_4( 15, 14, 10, 11 )
        Polygon_4( 15, 14, 10, 11 )
        Polygon_4( 13, 14, 15, 16 )
        Polygon_4( 14, 13,  9, 10 )
        Polygon_4( 16, 15, 11, 12 )
        Polygon_4( 13, 16, 12,  9 )
        Polygon_4( 12, 11, 10,  9 )
    Return


colonna:                  ; colonna gru
    LineColor( Strucc )
        MoveTo(    -2,    2,     -2 )  ; anello 1
        LineTo(    -2,    2,      2 )
        LineTo(     2,    2,      2 )
        LineTo(     2,    2,     -2 )
        LineTo(    -2,    2,     -2 )

        MoveTo(    -2,    2,     -2 )  ; anello x1/1
        LineTo(     2,    6,     -2 )
        MoveTo(     2,    2,     -2 ) 
        LineTo(    -2,    6,     -2 )

        MoveTo(    -2,    2,     -2 )  ; anello x1/2
        LineTo(    -2,    6,      2 )
        MoveTo(    -2,    2,      2 ) 
        LineTo(    -2,    6,     -2 )

        MoveTo(     2,    2,      2 )  ; anello x1/3
        LineTo(    -2,    6,      2 )
        MoveTo(    -2,    2,      2 ) 
        LineTo(     2,    6,      2 )

        MoveTo(     2,    2,      2 )  ; anello x1/4
        LineTo(     2,    6,     -2 )
        MoveTo(     2,    2,     -2 ) 
        LineTo(     2,    6,      2 )

        MoveTo(    -2,    6,     -2 )  ; anello x2/1
        LineTo(     2,   10,     -2 )
        MoveTo(     2,    6,     -2 ) 
        LineTo(    -2,   10,     -2 )

        MoveTo(    -2,    6,     -2 )  ; anello x2/2
        LineTo(    -2,   10,      2 )
        MoveTo(    -2,    6,      2 ) 
        LineTo(    -2,   10,     -2 )

        MoveTo(     2,    6,      2 )  ; anello x2/3
        LineTo(    -2,   10,      2 )
        MoveTo(    -2,    6,      2 ) 
        LineTo(     2,   10,      2 )

        MoveTo(     2,    6,      2 )  ; anello x2/4
        LineTo(     2,   10,     -2 )
        MoveTo(     2,    6,     -2 ) 
        LineTo(     2,   10,      2 )

        MoveTo(    -2,   10,     -2 )  ; anello x3/1
        LineTo(     2,   16,     -2 )
        MoveTo(     2,   10,     -2 ) 
        LineTo(    -2,   16,     -2 )

        MoveTo(    -2,   10,     -2 )  ; anello x3/2
        LineTo(    -2,   16,      2 )
        MoveTo(    -2,   10,      2 ) 
        LineTo(    -2,   16,     -2 )

        MoveTo(     2,   10,      2 )  ; anello x3/3
        LineTo(    -2,   16,      2 )
        MoveTo(    -2,   10,      2 ) 
        LineTo(     2,   16,      2 )

        MoveTo(     2,   10,      2 )  ; anello x3/4
        LineTo(     2,   16,     -2 )
        MoveTo(     2,   10,     -2 ) 
        LineTo(     2,   16,      2 )

        MoveTo(    -2,   16,     -2 )  ; anello x3/1
        LineTo(     2,   22,     -2 )
        MoveTo(     2,   16,     -2 ) 
        LineTo(    -2,   22,     -2 )

        MoveTo(    -2,   16,     -2 )  ; anello x3/2
        LineTo(    -2,   22,      2 )
        MoveTo(    -2,   16,      2 ) 
        LineTo(    -2,   22,     -2 )

        MoveTo(     2,   16,      2 )  ; anello x3/3
        LineTo(    -2,   22,      2 )
        MoveTo(    -2,   16,      2 ) 
        LineTo(     2,   22,      2 )

        MoveTo(     2,   16,      2 )  ; anello x3/4
        LineTo(     2,   22,     -2 )
        MoveTo(     2,   16,     -2 ) 
        LineTo(     2,   22,      2 )

        MoveTo(    -2,   22,     -2 )  ; anello x3/1
        LineTo(     2,   28,     -2 )
        MoveTo(     2,   22,     -2 ) 
        LineTo(    -2,   28,     -2 )

        MoveTo(    -2,   22,     -2 )  ; anello x3/2
        LineTo(    -2,   28,      2 )
        MoveTo(    -2,   22,      2 ) 
        LineTo(    -2,   28,     -2 )

        MoveTo(     2,   22,      2 )  ; anello x3/3
        LineTo(    -2,   28,      2 )
        MoveTo(    -2,   22,      2 ) 
        LineTo(     2,   28,      2 )

        MoveTo(     2,   22,      2 )  ; anello x3/4
        LineTo(     2,   28,     -2 )
        MoveTo(     2,   22,     -2 ) 
        LineTo(     2,   28,      2 )

        MoveTo(    -2,   28,     -2 )  ; anello x3/1
        LineTo(     2,   34,     -2 )
        MoveTo(     2,   28,     -2 ) 
        LineTo(    -2,   34,     -2 )

        MoveTo(    -2,   28,     -2 )  ; anello x3/2                   
        LineTo(    -2,   34,      2 )                                  
        MoveTo(    -2,   28,      2 )                                  
        LineTo(    -2,   34,     -2 )                                  
                                                                       
        MoveTo(     2,   28,      2 )  ; anello x3/3                   
        LineTo(    -2,   34,      2 )                                  
        MoveTo(    -2,   28,      2 )                                  
        LineTo(     2,   34,      2 )                                  
                                                                       
        MoveTo(     2,   28,      2 )  ; anello x3/4                   
        LineTo(     2,   34,     -2 )                                  
        MoveTo(     2,   28,     -2 )                                  
        LineTo(     2,   34,      2 )                                  
                                                                     
        MoveTo(    -2,   34,     -2 )  ; anello x3/1                   
        LineTo(     2,   40,     -2 )                                  
        MoveTo(     2,   34,     -2 )                                  
        LineTo(    -2,   40,     -2 )                                  
                                                                       
        MoveTo(    -2,   34,     -2 )  ; anello x3/2                   
        LineTo(    -2,   40,      2 )                                  
        MoveTo(    -2,   34,      2 )                                  
        LineTo(    -2,   40,     -2 )                                  
                                                                       
        MoveTo(     2,   34,      2 )  ; anello x3/3                   
        LineTo(    -2,   40,      2 )                                  
        MoveTo(    -2,   34,      2 )                                  
        LineTo(     2,   40,      2 )                                  
                                                                     
        MoveTo(     2,   34,      2 )  ; anello x3/4                   
        LineTo(     2,   40,     -2 )                                  
        MoveTo(     2,   34,     -2 )                                  
        LineTo(     2,   40,      2 )                                  
                                                                     
        MoveTo(    -2,   40,     -2 )  ; anello x3/1     
        LineTo(     2,   46,     -2 )                    
        MoveTo(     2,   40,     -2 )                    
        LineTo(    -2,   46,     -2 )                    
                                                         
        MoveTo(    -2,   40,     -2 )  ; anello x3/2     
        LineTo(    -2,   46,      2 )                    
        MoveTo(    -2,   40,      2 )                    
        LineTo(    -2,   46,     -2 )                    
                                                         
        MoveTo(     2,   40,      2 )  ; anello x3/3     
        LineTo(    -2,   46,      2 )                    
        MoveTo(    -2,   40,      2 )                    
        LineTo(     2,   46,      2 )                    
                                                         
        MoveTo(     2,   40,      2 )  ; anello x3/4     
        LineTo(     2,   46,     -2 )                    
        MoveTo(     2,   40,     -2 )                    
        LineTo(     2,   46,      2 )                    

        MoveTo(    -2,   52,     -2 )  ; anello 3   
        LineTo(    -2,   52,      2 )               
        LineTo(     2,   52,      2 )               
        LineTo(     2,   52,     -2 )               
        LineTo(    -2,   52,     -2 )               
                                                  
        LineTo(    -2,   40,     -2 )               
        MoveTo(    -2,   46,     -2 )  ; anello x3/1
        LineTo(     2,   52,     -2 )               
        MoveTo(     2,   46,     -2 )               
        LineTo(    -2,   52,     -2 )               
                                                  
        MoveTo(    -2,   46,     -2 )  ; anello x3/2
        LineTo(    -2,   52,      2 )               
        MoveTo(    -2,   46,      2 )               
        LineTo(    -2,   52,     -2 )               
                                                  
        MoveTo(     2,   46,      2 )  ; anello x3/3
        LineTo(    -2,   52,      2 )               
        MoveTo(    -2,   46,      2 )               
        LineTo(     2,   52,      2 )               
                                                  
        MoveTo(     2,   46,      2 )  ; anello x3/4
        LineTo(     2,   52,     -2 )               
        MoveTo(     2,   46,     -2 )               
        LineTo(     2,   52,      2 )               

        MoveTo(    -2,    2,     -2 )  ; colonna
        LineTo(    -2,   52,     -2 )
        MoveTo(    -2,    2,      2 )  
        LineTo(    -2,   52,      2 )
        MoveTo(     2,    2,      2 )  
        LineTo(     2,   52,      2 )
        MoveTo(     2,    2,     -2 )  
        LineTo(     2,   52,     -2 )
    Return


braccio: 
    LineColor( Strucc )
        MoveTo(   -19,   52,     -2 )   
        LineTo(    51,   52,     -2 )    
        LineTo(    51,   52,      2 )    
        LineTo(   -19,   52,      2 )    
        LineTo(   -19,   52,     -2 )    
                                      
        MoveTo(   -19,   55,     -1 )    
        LineTo(    51,   55,     -1 )    
        LineTo(    51,   55,      1 )    
        LineTo(   -19,   55,      1 )    
        LineTo(   -19,   55,     -1 )    
                                      
        MoveTo(   -19,   52,     -2 )    
        LineTo(   -19,   55,     -1 )    
        LineTo(   -19,   55,      1 )    
        LineTo(   -19,   52,      2 )    
        LineTo(   -19,   52,     -2 )    

        MoveTo(     0,   60,      0 )
        LineTo(   -19,   55,     -1 )
        MoveTo(     0,   60,      0 )
        LineTo(   -19,   55,      1 )

    ;t finale
        MoveTo(    57,   52,      0 )
        LineTo(    51,   52,     -2 )
        MoveTo(    57,   52,      0 )
        LineTo(    51,   52,      2 )
        MoveTo(    57,   52,      0 )
        LineTo(    51,   55,      1 )
        MoveTo(    57,   52,      0 )
        LineTo(    51,   55,     -1 )

    ; assi portanti della gru
        MoveTo(   -19,   52,     -2 )
        LineTo(   -16,   55,     -1 )
        LineTo(   -13,   52,     -2 )
        LineTo(   -10,   55,     -1 )
        LineTo(    -7,   52,     -2 )
        LineTo(    -4,   55,     -1 )
        LineTo(    -1,   52,     -2 )
        LineTo(     2,   55,     -1 )
        LineTo(     5,   52,     -2 )
        LineTo(     8,   55,     -1 )
        LineTo(    11,   52,     -2 )
        LineTo(    14,   55,     -1 )
        LineTo(    17,   52,     -2 )
        LineTo(    20,   55,     -1 )
        LineTo(    23,   52,     -2 )
        LineTo(    26,   55,     -1 )
        LineTo(    29,   52,     -2 )
        LineTo(    32,   55,     -1 )
        LineTo(    35,   52,     -2 )
        LineTo(    38,   55,     -1 )
        LineTo(    41,   52,     -2 )
        LineTo(    44,   55,     -1 )
        LineTo(    47,   52,     -2 )
        LineTo(    50,   55,     -1 )
        LineTo(    51,   52,     -2 )
        LineTo(    51,   55,     -1 )

        MoveTo(   -19,   52,      2 )
        LineTo(   -16,   55,      1 )
        LineTo(   -13,   52,      2 )
        LineTo(   -10,   55,      1 )
        LineTo(    -7,   52,      2 )
        LineTo(    -4,   55,      1 )
        LineTo(    -1,   52,      2 )
        LineTo(     2,   55,      1 )
        LineTo(     5,   52,      2 )
        LineTo(     8,   55,      1 )
        LineTo(    11,   52,      2 )
        LineTo(    14,   55,      1 )
        LineTo(    17,   52,      2 )
        LineTo(    20,   55,      1 )
        LineTo(    23,   52,      2 )
        LineTo(    26,   55,      1 )
        LineTo(    29,   52,      2 )
        LineTo(    32,   55,      1 )
        LineTo(    35,   52,      2 )
        LineTo(    38,   55,      1 )
        LineTo(    41,   52,      2 )
        LineTo(    44,   55,      1 )
        LineTo(    47,   52,      2 )
        LineTo(    50,   55,      1 )
        LineTo(    51,   52,      2 )
        LineTo(    51,   55,      1 )
                                    
        MoveTo(   -19,   55,     -1 )
        LineTo(   -16,   55,      1 )
        LineTo(   -13,   55,     -1 )
        LineTo(   -10,   55,      1 )
        LineTo(    -7,   55,     -1 )
        LineTo(    -4,   55,      1 )
        LineTo(    -1,   55,     -1 )
        LineTo(     2,   55,      1 )
        LineTo(     5,   55,     -1 )
        LineTo(     8,   55,      1 )
        LineTo(    11,   55,     -1 )
        LineTo(    14,   55,     -1 )
        LineTo(    17,   55,     -1 )
        LineTo(    20,   55,     -1 )
        LineTo(    23,   55,     -1 )
        LineTo(    26,   55,      1 )
        LineTo(    29,   55,     -1 )
        LineTo(    32,   55,      1 )
        LineTo(    35,   55,     -1 )
        LineTo(    38,   55,      1 )
        LineTo(    41,   55,     -1 )
        LineTo(    44,   55,      1 )
        LineTo(    47,   52,     -1 )
        LineTo(    50,   55,      1 )
        LineTo(    51,   55,     -1 )
        LineTo(    51,   55,      1 )

    ;Cavo Portante
    LineColor( 0x01 )
        MoveTo(    57,   52,      0 )
        LineTo(    57,   22,      0 )
    Return


gancio:
    SurfaceColor( 0x02 )
    Texture( "a-obj-1", "r8" )
    Transparenton
    AdjustTexture
    TexturePolygon( 4 )     
        TexturePt(  17,   0,   0 )
        TexturePt(  18,  62,   0 )
        TexturePt(  19,  62,  98 )
        TexturePt(  20,   0,  98 )
    
    AdjustTexture
    TexturePolygon( 4 )     
        TexturePt(  20,   0,  98 )
        TexturePt(  19,  62,  98 )
        TexturePt(  18,  62,   0 )
        TexturePt(  17,   0,   0 )

    TransparentOff
    Return


incima:
    LineColor( Strucc )
        MoveTo(    -2,    55,   -1 )
        LineTo(     0,    60,    0 )
        MoveTo(    -2,    55,    1 )
        LineTo(     0,    60,    0 )
        MoveTo(     2,    55,   -1 )
        LineTo(     0,    60,    0 )
        MoveTo(     2,    55,    1 )
        LineTo(     0,    60,    0 )

        MoveTo(     0,    60,    0 )
        LineTo(     2,    55,   -1 )
        MoveTo(     0,    60,    0 )
        LineTo(     2,    55,    1 )

        MoveTo(     0,    60,    0 )
        LineTo(    51,    55,   -1 )
        MoveTo(     0,    60,    0 )
        LineTo(    51,    55,    1 )

Jump( infine )

infine:
    GoIfNot( DayTime,  0x028C, 1 )
    Jump( TagEnd )

DayTime:
    LineColor( 0x16 )
        Dot( 0, 60, 0 )
    Return

TagEnd:
    Return 

ObjEnd:
    ENDMACRO
