;! " Adjustable altitude antenna (fixed scale)"
;? " Altitude: "=SML_Alt
;? " Scenery density required to show on (1-4): "=SML_Comp
; converted by A. Antonini ( with permission )

MACRO _Anten3
Local ObjEnd, ObjReturn, Pcall, Night, Step1, Step2, Step3, Step4

Area( SML_Lat, SML_Lon, 38 km, ObjEnd )
    GoIfOut(  ObjEnd,  0x0346, SML_Comp,  4  ) 
    PerspectiveCall( Pcall )
    Jump( ObjEnd )

Pcall:
    Perspective
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )

        

    PointsList( 0, 8 )
    Point(      0,      0,      0   )  ;0
    Point(      0,      6,      0   )  ;1    
    Point(      0,     12,      0   )  ;2
    Point(      0,     18,      0   )  ;3
    Point(      0,     24,      0   )  ;4
    Point(      0,     30,      0   )  ;5    
    Point(      0,     36,      0   )  ;6
    Point(      0,     42,      0   )  ;7

    LineColor(  0x04 )  
        MoveToPoint(  0  )
        LineToPoint(  1  )
    LineColor( 0x05  )
        MoveToPoint(  1  )
        LineToPoint(  2  )
    LineColor( 0x04  )
        MoveToPoint(  2  )
        LineToPoint(  3  )
    LineColor( 0x05 )
        MoveToPoint(  3  )
        LineToPoint(  4  )
    LineColor( 0x04 )
        MoveToPoint(  4  )
        LineToPoint(  5  )
    LineColor( 0x05 )
        MoveToPoint(  5  )
        LineToPoint(  6  )
    LineColor( 0x04 )
        MoveToPoint(  6  )
        LineToPoint(  7  )

    GoIfOut(  Night,  0x028C, 2, 4 )
    LineColor(  0x0F )
        DottedLine(   0,   10,    0,   0,  40,   0,   8  )

Night:
    LineColor( 0x04 )
    GoIfNot(  Step1, 0x282, 0x000B )
    LineColor( 0x15 )
Step1:
    DottedLine(  0,   12,   0,   0,  42,  0,  8   )
    LineColor( 0x04 )
    GoIfNot( Step2, 0x282, 0x00B0 )
    LineColor( 0x15 )
Step2:
    DottedLine(  0,   12,   0,   0,  42,  0,  8   )
    LineColor( 0x04 )
    GoIfNot( Step3, 0x282, 0x0B00 )
    LineColor( 0x15 )
Step3:
    DottedLine(  0,   12,   0,   0,  42,  0,  8   )
    LineColor( 0x04 )
    GoIfNot( Step4, 0x282, 0xB000 )
    LineColor( 0x15 )
Step4:
    DottedLine(  0,   12,   0,   0,  42,  0,  8   )

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
