;! " Adjustable altitude Antenna "
;? " Altitude: "=SML_Alt
;? " Scenery density required to show on (1-4): "=SML_Comp
; Converted by A. Antonini with permission fro Airport author

MACRO _Anten1

Local ObjEnd, Pcall, ObjReturn, Dwg

Area(  SML_Lat, SML_Lon, 30 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall )
    Jump( ObjEnd )

Pcall:
    Perspective
    CondRefPoint( ObjReturn, 5000, 18, 0, 0.1, SML_Lat, SML_Lon, SML_Alt )

    PointsList( 0, 7 )
    Point(     0,      0,      0  )   ;0
    Point(     0,      2,      0  )   ;1    
    Point(     0,      4,      0  )   ;2
    Point(     0,      6,      0  )   ;3
    Point(     0,      8,      0  )   ;4
    Point(     0,     10,      0  )   ;5    
    Point(     0,     12,      0  )   ;6
    
    LineColor( 0x04 )  
        MoveToPoint(  0  )
        LineToPoint(  1  )
    LineColor( 0x05 )
        MoveToPoint(  1  )
        LineToPoint(  2  )
    LineColor( 0x04 )
        MoveToPoint(  2  )
        LineToPoint(  3  )
    LineColor( 0x05 )
        MoveToPoint(  3  )
        LineToPoint(  4  )
    LineColor( 0x04 )
        MoveToPoint(  4  )
        LineToPoint(  5  )
    LineColor( 0x05 )
        MoveToPoint(  5  )
        LineToPoint(  6  )

    GoIfOut( ObjReturn, 0x028C, 2, 4 )
    LineColor( 0x0F )
        DottedLine(   0,   10,    0,   0,  12,   0,   4  )

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
