;! " Airport ATIS Antenna "
;? " Heading [HDG] "=SML_Heading
; converted by A. Antonini ( with permission )

MACRO _Airptati

Local ObjEnd, Pcall1, ObjReturn, Dwg, Scall1, CrashDet

Area( SML_Lat, SML_Lon, 20 km, ObjEnd ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Goto( ObjEnd )

Pcall1:
    Perspective

Scall1:    
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = 8
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn: 
    Return

Dwg:
    PointsList( 1, 12 )
 		Point(   0,   0,  0  ) ;1
 		Point(   0,  20,  0  ) ;2
    Point(   0,  40,  0  ) ;3
    Point(   0,  60,  0  ) ;4
    Point(   0,  80,  0  ) ;5
    Point(   0, 100,  0  ) ;6
    Point(   0, 120,  0  ) ;7
    Point(   0, 140,  0  ) ;8

    Point(   50,  0,  0  ) ;9
    Point(  -50,  0,  0  ) ;10
    Point(    0,  0, 50  ) ;11
    Point(    0,  0,-50  ) ;12

	  LineColour( Red )
    		MoveToPoint(   1  )
    		LineToPoint(   2  )
    LineColour( White )
        MoveToPoint(   2  )
        LineToPoint(   3  )
    LineColour( Red )
        MoveToPoint(   3  )
        LineToPoint(   4  )
    LineColour( White )
        MoveToPoint(   4  )
        LineToPoint(   5  )
    LineColour( Red )
        MoveToPoint(   5  )
        LineToPoint(   6  )
    LineColour(  White  )
        MoveToPoint(   6  )
        LineToPoint(   7  )
    LineColour( Red )
        MoveToPoint(   7  )
        LineToPoint(   8  )
    LineColour(  LightGrey  )
        MoveToPoint(   9  )
        LineToPoint(   4  )
        MoveToPoint(  10  )
        LineToPoint(   4  )
        MoveToPoint(  11  )
        LineToPoint(   4  )
        MoveToPoint(  12  )
        LineToPoint(   4  )
    GoIfOut(  CrashDet, Day_Time, 2, 4  )
    LineColour(  NightWhite )
    DottedLine( 0, 20, 0, 0, 140, 0, 4 )

    Goto( CrashDet )

CrashDet:    
    GoIfOutCube( ObjReturn, -1, 1, 0, 60, -1, 1 )
    SetVar( Crash_flag, 4 )
        
ObjEnd:
ENDMACRO
