;! " Airport landing T "
;? " Heading [HDG] "=SML_Heading
;? " Scale "=SML_Scale
;? " Altitude "=SML_Alt
;? " Scenery density required to show on (1-4) "=SML_Comp
;? " Smooth Texture (0-1) "=SML_Smooth
;? " Color 1 (0-1) - see macro for details "=SML_Clr1
;? " Color 2 (0-1) - see macro for details "=SML_Clr2
;? " Color 3 (0-3) - see macro for details "=SML_Clr3
;? " Color 4 (0-2) - see macro for details "=SML_Clr4
; Converted by Alessandro Antonini (with permission)

;            CODE          PANNEAUX
;
; color   1 =  0  >>> Landings prohibited    
;           =  1  >>> Warning: special cares to be taking on approach   
;                              or landing course              
;
; color   2 =  0  >>> rien
;           =  1  >>> circuit on the right
;
; color   3 =  0  >>> rien
;           =  1  >>> Choppers flying    
;           =  2  >>> Parachutists on course
;           =  3  >>> VOLS DE PLANEURS EN COURS
;
; color   4 =  0  >>> rien
;           =  1  >>> Landings, take-offs and traffick on runways and     
;                     taxiways
;           =  2  >>> Take off and landing on runways only              

MACRO _Airesign

Local ObjEnd, Pcall1, Dwg, ObjReturn, aire, croixb, tdpdr,
      helppla, halteres, test1, test2, test3, rien, testh1, testh2,
      testh3, rienh

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 )
    Priority(  Pcall1, 0x25  )
    Jump(  ObjEnd  )


Pcall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    Rotate( Dwg,  0,  0,  SML_Heading )
    Return

Dwg:
    PointsList( 0, 24 )
    Point(     13,    0,    13  )              
    Point(     13,    0,   -13  )              
    Point(    -13,    0,   -13  )              
    Point(    -13,    0,    13  );0 1 2 3      
    Point(     12,    0,    12  )              
    Point(     12,    0,   -12  )              
    Point(    -12,    0,   -12  )              
    Point(    -12,    0,    12  );4 5 6 7      
    Point(    -11,    0,    10  )              
    Point(     -3,    0,    10  )              
    Point(     -3,    0,     5  )              
    Point(    -11,    0,     5  );8 9 10 11    
    Point(    -10,    0,     3  )              
    Point(     -5,    0,     3  )              
    Point(     -5,    0,    -2  )              
    Point(    -10,    0,    -2  );12 13 14 15  
    Point(    -10,    0,    -5  )              
    Point(     -5,    0,    -5  )              
    Point(     -5,    0,   -10  )              
    Point(    -10,    0,   -10  );16 17 18 19  
    Point(     -3,    0,     3  )              
    Point(      2,    0,     3  )              
    Point(      2,    0,    -2  )              
    Point(     -3,    0,    -2  );20 21 22 23  
    Call( aire )
    Call( croixb )
    Call( tdpdr )
    Call( helppla )
    Call( halteres )
    Return

aire:
    SurfaceColor( White )
    StartSurface
        MoveToPoint( 0 )
        LineToPoint( 1 )
        LineToPoint( 2 )
        LineToPoint( 3 )
    CloseSurface

    SurfaceColor( Grey )
    StartSurface
        MoveToPoint( 4 )
        LineToPoint( 5 )
        LineToPoint( 6 )
        LineToPoint( 7 )
    CloseSurface
    Return

croixb:
    If ( Sml_Smooth == 1 )
        Texture( "airpt003", "oav" )
        TextureSmoothOn
    Else
        Texture( "airpt003", "oav" )
    EndIf

    If ( SML_Clr1 == 1 )
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 12,  135,  163 )
            TexturePt( 13,  111,  163 )
            TexturePt( 14,  111,  187 )
            TexturePt( 15,  135,  187 )
    Else
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 12,   88,  163 )
            TexturePt( 13,  112,  163 )
            TexturePt( 14,  112,  187 )
            TexturePt( 15,   88,  187 )
    EndIf
    Return

tdpdr:
    RepeatBitmap
    If ( SML_Clr2 == 1 )
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt(  8,  136,  187 )
            TexturePt(  9,  167,  187 )
            TexturePt( 10,  167,  163 )
            TexturePt( 11,  136,  163 )
        Return
    Else
        Return
    EndIf

helppla:
    SetVar( 0x312, SML_Clr3 )
        
    test1:
        GoIfOut( test2, 0x312,  1,  2 )
        RepeatBitmap
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 16,   30,  106 )
            TexturePt( 17,   45,  106 )
            TexturePt( 18,   45,   78 )
            TexturePt( 19,   30,   78 )

    test2:
        GoIfOut( test3, 0x312,  2,  3 )
        RepeatBitmap         
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 16,   47,  106 )
            TexturePt( 17,   69,  106 )
            TexturePt( 18,   69,   78 )
            TexturePt( 19,   47,   78 )

    test3:
        GoIfOut( rien, 0x312,  3,  4 )
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 16,    8,  106 )
            TexturePt( 17,   24,  106 )
            TexturePt( 18,   24,   78 )
            TexturePt( 19,    8,   78 )

    rien:
        Return

halteres:
    SetVar( 0x314, SML_Clr4 )
       
    testh1:
        GoIfOut( testh2, 0x314, 1, 2 )
        RepeatBitmap
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 20,  225,  199 )
            TexturePt( 21,  249,  199 )
            TexturePt( 22,  249,  187 )
            TexturePt( 23,  225,  187 )

    testh2:
        GoIfOut( rienh, 0x314, 2, 3 )
        RepeatBitmap
        AdjustTexture
        TexturePolygon( 4 )
            TexturePt( 20,  225,  216 )
            TexturePt( 21,  249,  216 )
            TexturePt( 22,  249,  204 )
            TexturePt( 23,  225,  204 )

    rienh:
    If ( Sml_Smooth == 0 )
        TextureSmoothOff
        Return
    Else
        Return 
    EndIf

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
