;! " Villa with threshing-floor "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Min. scenery density to show on (1.Spa 2.Nor 3.Den 4.VDe): "=SML_Comp
;? " Roof Color: "=SML_Roof
;? " Walls Color: "=SML_Wall



MACRO _Villa1

Local Roofc, Wallc, Pcall, Scall, Dwg, ObjEnd, ObjReturn, haiedt, haiear,
      haieavdt, haieavg, maison, haieg

; setup default
Wallc = 0x03
Roofc = 0x05

If ( SML_Wall == 0 )
    Wallc = 0x00
EndIf
If ( SML_Wall == 1 )
    Wallc = 0x01
EndIf
If ( SML_Wall == 2 )
    Wallc = 0x02
EndIf
If ( SML_Wall == 3 )
    Wallc = 0x03
EndIf
If ( SML_Wall == 4 )
    Wallc = 0x04
EndIf
If ( SML_Wall == 5 )
    Wallc = 0x05
EndIf
If ( SML_Wall == 6 )
    Wallc = 0x06
EndIf
If ( SML_Wall == 7 )
    Wallc = 0x07
EndIf
If ( SML_Wall == 8 )
    Wallc = 0x08
EndIf
If ( SML_Wall == 9 )
    Wallc = 0x09
EndIf

If ( SML_Roof == 0 )
    Roofc = 0x00
EndIf
If ( SML_Roof == 1 )
    Roofc = 0x01
EndIf
If ( SML_Roof == 2 )
    Roofc = 0x02
EndIf
If ( SML_Roof == 3 )
    Roofc = 0x03
EndIf
If ( SML_Roof == 4 )
    Roofc = 0x04
EndIf
If ( SML_Roof == 5 )
    Roofc = 0x05
EndIf
If ( SML_Roof == 6 )
    Roofc = 0x06
EndIf
If ( SML_Roof == 7 )
    Roofc = 0x07
EndIf
If ( SML_Roof == 8 )
    Roofc = 0x08
EndIf
If ( SML_Roof == 9 )
    Roofc = 0x09
EndIf


Area( SML_Lat, SML_Lon, 30 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )    
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Jump( ObjEnd )

Pcall:
    Perspective

Scall:
;    CondRefPoint( ObjReturn, 7000, 18, 0, 1, SML_Lat, SML_Lon, 0 )
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale * SML_Scale) / 100
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    Call( haiedt )
    Call( haieg )
    Call( haiear )
    Call( haieavdt)
    Call( haieavg )
    Call( maison )
    Return
    
haiedt:
    ;haie dt
    PointsList( 0, 12 )
    Point(    100,     0,   -150  )   ;face
    Point(    100,    13,   -150  )
    Point(    100,    13,    100  )
    Point(    100,     0,    100  )
    Point(     91,     0,     -7  )    ;extremit 1
    Point(     91,    13,     -7  )
    Point(    110,    13,     -7  )
    Point(    110,     0,     -7  )
    Point(     91,     0,      7  )    ;extrmit 2
    Point(     91,    13,      7  )
    Point(    110,    13,      7  )
    Point(    110,     0,      7  )
    

    Texture( "AIRPT005", "OAV" )
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,     0,    136 )
        TexturePt(  5,     0,    149 )
        TexturePt(  6,    20,    149 )
        TexturePt(  7,    20,    136 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  8,    20,    136 )
        TexturePt(  9,    20,    149 )
        TexturePt( 10,     0,    149 )
        TexturePt( 11,     0,    136 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,    20,    136 )
        TexturePt(  1,    20,    149 )
        TexturePt(  2,   255,    149 )
        TexturePt(  3,   255,    136 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,     0,    136 )
        TexturePt(  6,     0,    149 )
        TexturePt(  5,    20,    149 )
        TexturePt(  4,    20,    136 )
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 11,     0,    136 )
        TexturePt( 10,     0,    149 )
        TexturePt(  9,    20,    149 )
        TexturePt(  8,    20,    136 )
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,   255,    136 )
        TexturePt(  2,   255,    149 )
        TexturePt(  1,    20,    149 )
        TexturePt(  0,    20,    136 )
    TransparentOff
    Return
    
haieg:    
    ;haie g
    PointsList( 0, 12 )
    Point(   -150,     0,   -150  )   ;face
    Point(   -150,    13,   -150  )
    Point(   -150,    13,    100  )
    Point(   -150,     0,    100  )

    Point(   -141,     0,     -7  )   ;extremit 1
    Point(   -141,    13,     -7  )
    Point(   -160,    13,     -7  )
    Point(   -160,     0,     -7  )

    Point(   -141,     0,      7  )   ;extrmit 2
    Point(   -141,    13,      7  )
    Point(   -160,    13,      7  )
    Point(   -160,     0,      7  )

    RepeatBitmap
    TransparentOn 
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  4,     0,    136 )
        TexturePt(  5,     0,    149 )
        TexturePt(  6,    20,    149 )
        TexturePt(  7,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  8,    20,    136 )
        TexturePt(  9,    20,    149 )
        TexturePt( 10,     0,    149 )
        TexturePt( 11,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  0,    20,    136 )
        TexturePt(  1,    20,    149 )
        TexturePt(  2,   255,    149 )
        TexturePt(  3,   255,    136 )
  
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  7,    20,    136 )
        TexturePt(  6,    20,    149 )
        TexturePt(  5,     0,    149 )
        TexturePt(  4,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt( 11,     0,    136 )
        TexturePt( 10,     0,    149 )
        TexturePt(  9,    20,    149 )
        TexturePt(  8,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  3,   255,    136 )
        TexturePt(  2,   255,    149 )
        TexturePt(  1,    20,    149 )
        TexturePt(  0,    20,    136 )
    TransparentOff
    Return           
  
haiear:
    ;haie ar
    PointsList( 0, 12 )
    Point(    100,     0,   100 )   ;face
    Point(    100,    13,   100 )
    Point(   -150,    13,   100 )
    Point(   -150,     0,   100 )
    Point(      9,     0,   107 )    ;extremit 1
    Point(      9,    13,   107 )
    Point(      9,    13,    93 )
    Point(      9,     0,    93 )
    Point(     -9,     0,   107 )    ;extrmit 2
    Point(     -9,    13,   107 )
    Point(     -9,    13,    93 )
    Point(     -9,     0,    93 )
    
    RepeatBitmap
    TransparentOn 

    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  4,     0,    136 )
        TexturePt(  5,     0,    149 )
        TexturePt(  6,    20,    149 )
        TexturePt(  7,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  8,    20,    136 )
        TexturePt(  9,    20,    149 )
        TexturePt( 10,     0,    149 )
        TexturePt( 11,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  0,    20,    136 )
        TexturePt(  1,    20,    149 )
        TexturePt(  2,   255,    149 )
        TexturePt(  3,   255,    136 )
  
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  7,    20,    136 )
        TexturePt(  6,    20,    149 )
        TexturePt(  5,     0,    149 )
        TexturePt(  4,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt( 11,     0,    136 )
        TexturePt( 10,     0,    149 )
        TexturePt(  9,    20,    149 )
        TexturePt(  8,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  3,   255,    136 )
        TexturePt(  2,   255,    149 )
        TexturePt(  1,    20,    149 )
        TexturePt(  0,    20,    136 )
    TransparentOff
    Return

haieavdt:  
    ;haie av dt
    PointsList( 0, 12 )
    Point(    100,     0,   -150 )   ;face
    Point(    100,    13,   -150 )
    Point(     10,    13,   -150 )
    Point(     10,     0,   -150 )
                         
    Point(     70,     0,   -140 )   ;extremit 1
    Point(     70,    13,   -140 )
    Point(     70,    13,   -160 )
    Point(     70,     0,   -160 )
                         
    Point(     50,     0,   -140 )   ;extrmit 2
    Point(     50,    13,   -140 )
    Point(     50,    13,   -160 )
    Point(     50,     0,   -160 )

    RepeatBitmap
    TransparentOn 
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  4,     0,    136 )
        TexturePt(  5,     0,    149 )
        TexturePt(  6,    20,    149 )
        TexturePt(  7,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  8,    20,    136 )
        TexturePt(  9,    20,    149 )
        TexturePt( 10,     0,    149 )
        TexturePt( 11,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  0,    20,    136 )
        TexturePt(  1,    20,    149 )
        TexturePt(  2,   255,    149 )
        TexturePt(  3,   255,    136 )
  
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  7,    20,    136 )
        TexturePt(  6,    20,    149 )
        TexturePt(  5,     0,    149 )
        TexturePt(  4,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt( 11,     0,    136 )
        TexturePt( 10,     0,    149 )
        TexturePt(  9,    20,    149 )
        TexturePt(  8,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  3,   255,    136 )
        TexturePt(  2,   255,    149 )
        TexturePt(  1,    20,    149 )
        TexturePt(  0,    20,    136 )
    TransparentOff
    Return
    
haieavg:
    ;haie av g
    PointsList( 0, 12 )
    Point(    -10,    0,   -150  )   ;face
    Point(    -10,   13,   -150  )
    Point(   -150,   13,   -150  )
    Point(   -150,    0,   -150  )
                        
    Point(    -70,    0,   -140  )   ;extremit 1
    Point(    -70,   13,   -140  )
    Point(    -70,   13,   -160  )
    Point(    -70,    0,   -160  )
                        
    Point(    -90,    0,   -140  )   ;extrmit 2
    Point(    -90,   13,   -140  )
    Point(    -90,   13,   -160  )
    Point(    -90,    0,   -160  )

    RepeatBitmap
    TransparentOn 

    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  4,     0,    136 )
        TexturePt(  5,     0,    149 )
        TexturePt(  6,    20,    149 )
        TexturePt(  7,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  8,    20,    136 )
        TexturePt(  9,    20,    149 )
        TexturePt( 10,     0,    149 )
        TexturePt( 11,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  0,    20,    136 )
        TexturePt(  1,    20,    149 )
        TexturePt(  2,   255,    149 )
        TexturePt(  3,   255,    136 )
  
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  7,    20,    136 )
        TexturePt(  6,    20,    149 )
        TexturePt(  5,     0,    149 )
        TexturePt(  4,     0,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt( 11,     0,    136 )
        TexturePt( 10,     0,    149 )
        TexturePt(  9,    20,    149 )
        TexturePt(  8,    20,    136 )
    AdjustTexture 
    TexturePolygon( 4 )
        TexturePt(  3,   255,    136 )
        TexturePt(  2,   255,    149 )
        TexturePt(  1,    20,    149 )
        TexturePt(  0,    20,    136 )
    TransparentOff
    Return

  
maison:  
    ;maison 
    PointsList( 0, 27 )
    Point(    -40,    0,     20   ) ;0
    Point(     40,    0,     20   ) ;1
    Point(     40,    0,    -20   ) ;2
    Point(    -40,    0,    -20   ) ;3
    Point(    -40,   12,     20   ) ;4
    Point(     40,   12,     20   ) ;5
    Point(     40,   12,    -20   ) ;6
    Point(    -40,   12,    -20   ) ;7
    Point(    -40,   20,     12   ) ;8
    Point(     40,   20,     12   ) ;9
    Point(     40,   20,    -12   ) ;10
    Point(    -40,   20,    -12   ) ;11
    Point(    -28,   32,      0   ) ;12
    Point(     28,   32,      0   ) ;13
    Point(     98,    0,     98   ) ;14
    Point(     98,    0,   -148   ) ;15
    Point(   -148,    0,   -148   ) ;16
    Point(   -148,    0,     98   ) ;17
    Point(     10,    0,   -148   ) ;18
    Point(     10,    0,    -20   ) ;19
    Point(    -10,    0,    -20   ) ;20
    Point(    -10,    0,   -148   ) ;21
    Point(      0,    0,      0   ) ;22
    Point(    -80,    0,    -40   ) ;23
    Point(   -120,    0,    -40   ) ;24
    Point(   -120,    0,    -90   ) ;25
    Point(    -80,    0,    -90   ) ;26


    SurfaceColor( Wallc )  ;maison
        Polygon_4(  0,  1,  5,  4 )
        Polygon_6(  1,  5,  9, 10,  6,  2 )
        Polygon_4(  2,  3,  7,  6 )
        Polygon_6(  0,  3,  7, 11,  8,  4 )

    SurfaceColor( Roofc )
        Polygon_6(  4,  5,  9, 13, 12,  8 )
        Polygon_3(  9, 10, 13 )
        Polygon_6(  6,  7, 11, 12, 13, 10 )
        Polygon_3(  8, 12, 11 )
    Return

ObjEnd:
    ENDMACRO
