;! " Transformer "
;? " Scale "=SML_Scale
;? " Altitude "=SML_Alt
;? " Heading [HDG] "=SML_Heading
;? " Scenery density required to show on "=SML_Comp
;? " Sides Color "=SML_Wall
;? " Center Part Color "=SML_Cent
; converted by Alessandro Antonini (with permission)

MACRO _Transf1

Local ObjEnd, Pcall1, Scall1, Dwg, ObjReturn

Area( SML_Lat, SML_Lon, 20 km, ObjEnd )
        
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1  )
    ShadowCall( Scall1  )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    _CondRefPoint( 0x77, ObjReturn, 3000, 48, 0, 1 m, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale)/100) * 10
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
		PointsList( 0, 16 )     ;transformateur
    Point(     0,       0,    -30   )  ;0 
    Point(   -35,       0,    -30   )  ;1 
    Point(   -35,      40,    -30   )  ;2 
    Point(     0,      40,    -30   )  ;3 
    Point(     0,       0,      0   )  ;4 
    Point(   -35,       0,      0   )  ;5 
    Point(   -35,      40,      0   )  ;6 
    Point(     0,      40,      0   )  ;7 
    Point(     0,       0,     30   )  ;8 
    Point(   -35,       0,     30   )  ;9 
    Point(   -35,      40,     30   )  ;10
    Point(     0,      40,     30   )  ;11
    Point(     0,       0,     60   )  ;12
    Point(   -35,       0,     60   )  ;13
    Point(   -35,      40,     60   )  ;14
    Point(     0,      40,     60   )  ;15
        
    If (SML_Wall == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Wall == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Wall == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Wall == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Wall == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Wall == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Wall == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Wall == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Wall == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Wall == 9)
      SurfaceColor( SandLight )
    EndIf
    Polygon_4(    0,  1,  2,  3  )
    Polygon_4(    4,  0,  3,  7  )
    Polygon_4(    6,  2,  1,  5  )
    Polygon_4(    7,  3,  2,  6  )

    If (SML_Cent == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Cent == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Cent == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Cent == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Cent == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Cent == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Cent == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Cent == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Cent == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Cent == 9)
      SurfaceColor( SandLight )
    EndIf
    Polygon_4(    8,  4,  7, 11  )
    Polygon_4(   10,  6,  5,  9  )
    Polygon_4(   11,  7,  6, 10  )

    If (SML_Wall == 0)
      SurfaceColor( Black )
    EndIf        
    If (SML_Wall == 1)
      SurfaceColor( DarkGrey )
    EndIf        
    If (SML_Wall == 2)
      SurfaceColor( Grey )
    EndIf        
    If (SML_Wall == 3)
      SurfaceColor( LightGrey )
    EndIf        
    If (SML_Wall == 4)
      SurfaceColor( White )
    EndIf        
    If (SML_Wall == 5)
      SurfaceColor( Red )
    EndIf        
    If (SML_Wall == 6)
      SurfaceColor( Green )
    EndIf
    If (SML_Wall == 7)
      SurfaceColor( Blue )
    EndIf
    If (SML_Wall == 8)
      SurfaceColor( SandDark )
    EndIf
    If (SML_Wall == 9)
      SurfaceColor( SandLight )
    EndIf
    Polygon_4(  15,  14,  13,  12  )
    Polygon_4(  12,   8,  11,  15  )
    Polygon_4(  14,  10,   9,  13  )
    Polygon_4(  15,  11,  10,  14  )
    Return

ObjEnd:
ENDMACRO


