;! " Simple ship macro "
;? " Scale "=SML_Scale
;? " Altitude "=SML_Alt
;? " Heading [HDG] "=SML_Heading
;? " Minimum scenery density to show on (1-4) "=SML_Comp
;? " Walls color "=SML_Wall
;? " Upper bridge color "=SML_Av
;? " Lower bridge color "=SML_Ar
; Converted by Alessandro Antonini (with permission)

MACRO _Ship2

Local ObjEnd, Pcall1, Scall1, ObjReturn, Dwg

Area( SML_Lat, SML_Lon, 20 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsListVect( 0, 14 )
    PointVect(      0,      0,      0 ) ; 1
    PointVect(      0,     10,     40 ) ; 2
    PointVect(    -25,     10,    -10 ) ; 3
    PointVect(    -20,     10,    -80 ) ; 4
    PointVect(     20,     10,    -80 ) ; 5
    PointVect(     25,     10,    -10 ) ; 6
    PointVect(      0,      0,     35 ) ; 7
    PointVect(    -20,      0,    -10 ) ; 8
    PointVect(    -15,      0,    -80 ) ; 9
    PointVect(     15,      0,    -80 ) ; 10
    PointVect(      0,     10,      0 ) ; 11
    PointVect(     20,      0,    -10 ) ; 12
    PointVect(      0,     10,      0 ) ; 13
    PointVect(      0,    100,      0 ) ; 14

    SurfaceColor( 0x0568 )
    Polygon_4(  1,  2,  7,  6 ) ;flanc avG
    Polygon_4(  2,  3,  8,  7 ) ;flanc G
    Polygon_4(  4,  5, 11,  9 ) ;flanc D
    Polygon_4(  6, 11,  5,  1 ) ;flanc avD
    Polygon_4(  3,  4,  9,  8 )  ;ar

    If (SML_Av == 0)
      GradColor( Black )
    EndIf        
    If (SML_Av == 1)
      GradColor( DarkGrey )
    EndIf        
    If (SML_Av == 2)
      GradColor( Grey )
    EndIf        
    If (SML_Av == 3)
      GradColor( LightGrey )
    EndIf        
    If (SML_Av == 4)
      GradColor( White )
    EndIf        
    If (SML_Av == 5)
      GradColor( Red )
    EndIf        
    If (SML_Av == 6)
      GradColor( Green )
    EndIf
    If (SML_Av == 7)
      GradColor( Blue )
    EndIf
    If (SML_Av == 8)
      GradColor( SandDark )
    EndIf
    If (SML_Av == 9)
      GradColor( SandLight )
    EndIf
    Concave
    GradPolygon_4(  2, 10,  5, 1 ) ;pont av

    If (SML_Ar == 0)
      GradColor( Black )
    EndIf        
    If (SML_Ar == 1)
      GradColor( DarkGrey )
    EndIf        
    If (SML_Ar == 2)
      GradColor( Grey )
    EndIf        
    If (SML_Ar == 3)
      GradColor( LightGrey )
    EndIf        
    If (SML_Ar == 4)
      GradColor( White )
    EndIf        
    If (SML_Ar == 5)
      GradColor( Red )
    EndIf        
    If (SML_Ar == 6)
      GradColor( Green )
    EndIf
    If (SML_Ar == 7)
      GradColor( Blue )
    EndIf
    If (SML_Ar == 8)
      GradColor( SandDark )
    EndIf
    If (SML_Ar == 9)
      GradColor( SandLight )
    EndIf
    GradPolygon_5( 10, 5, 4, 3, 2 ) ;pont ar      
    
    LineColor( White )
    MoveToPoint( 12 )
    LineToPoint( 13 )
    Return

ObjEnd:
ENDMACRO
