;! " Pine tree "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Altitude: "=SML_Alt
;? " Required scenery density to show on (1-4): "=SML_Comp 
;? " Is season change required (0-1): "=SML_Change

; Converted by Alessandro Antonini ( with permission )


MACRO _Sapin

Local ObjEnd, Pcall1, ombre, Automne, Ete, Printemps, Faces, ObjReturn

Area( SML_Lat, SML_Lon,  9 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( ombre )
    Jump( ObjEnd )

Pcall1:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale)/100)*10

    PointsList( 0, 8 )
    Point(   -31,     0,    0 )  ;face
    Point(   -31,    84,    0 )
    Point(    35,    84,    0 )
    Point(    35,     0,    0 )

    Point(     0,     0,  -31 )  ;Profil
    Point(     0,    84,  -31 )
    Point(     0,    84,   35 )
    Point(     0,     0,   35 )
  
    GoIfOut( Automne, 0x6F8, 0, 2 )
    GoIfOut( Ete, 0x6F8, 0, 1 )
    GoIfOut( Printemps, 0x6F8, 0, 0 )

    If( SML_Change == 1 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - north hemisphere
    EndIf

    If( SML_Change == 0 )
        Texture( "AIRPT004", "OAV" ) ; summer - south hemisphere
    EndIf
    Jump( Faces )

Printemps:
    If( SML_Change == 1 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn - south hemisphere
    EndIf
    Jump( Faces )

Ete:
    If( SML_Change == 1 )
        Texture( "AIRPT004", "OAV" ) ; summer - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - south hemisphere
    EndIf
    Jump( Faces )

Automne:
    If( SML_Change == 1 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn -north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - south hemisphere
    EndIf
    Jump( Faces )

Faces:
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,    189,      1 ) 
        TexturePt(  1,    189,     85 )
        TexturePt(  2,    255,     85 )
        TexturePt(  3,    255,      1 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,    189,      1 )
        TexturePt(  5,    189,     85 )
        TexturePt(  6,    255,     85 )
        TexturePt(  7,    255,      1 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,    189,      1 )
        TexturePt(  2,    189,     85 )
        TexturePt(  1,    255,     85 )
        TexturePt(  0,    255,      1 )
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,    189,      1 )
        TexturePt(  6,    189,     85 )
        TexturePt(  5,    255,     85 )
        TexturePt(  4,    255,      1 )
    TransparentOff
    Return

ombre:
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    PointsList( 0, 11 )
    Point( -25,      0,    0  );face
    Point( -31,     22,    0  )
    Point(   1,     84,    0  )
    Point(  35,     17,    0  )
    Point(  22,      0,    0  )
    Point(  18,     13,    0  )

    Point(   0,      0,  -25  );Profil
    Point(   0,     22,  -31  )
    Point(   0,     84,    1  )
    Point(   0,     17,   35  )
    Point(   0,      0,   22  )

    SurfaceColor( 0x18 ) 
    Polygon_5(  0,  1,  2,  3,  4 )
    Polygon_5(  5,  6,  7,  8,  9 )
    Polygon_5(  4,  3,  2,  1,  0 )
    Polygon_5(  9,  8,  7,  6,  5 )
    Return

ObjReturn:
    Return
ObjEnd:
ENDMACRO
