;! " High-Voltage Pylon "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Structure color: "=SML_Struc
;? " Altitude: "=SML_Alt
;? " Scenery density reuqired to show on (1-4): "=SML_Comp
; converted by A. Antonini (with permission)

MACRO HvPylon

Local ObjEnd, Pcall, Dwg, ObjReturn, Strucc, nocrash

; assume default color grey

    Strucc = 0x02
    If ( SML_Struc == 0 )
        Strucc = 0x00   
    EndIf                
    If ( SML_Struc == 1 )
        Strucc = 0x01   
    EndIf                
    If ( SML_Struc == 2 )
        Strucc = 0x02   
    EndIf                
    If ( SML_Struc == 3 )
        Strucc = 0x03   
    EndIf                
    If ( SML_Struc == 4 )
        Strucc = 0x04   
    EndIf                
    If ( SML_Struc == 5 )
        Strucc = 0x05   
    EndIf                
    If ( SML_Struc == 6 )
        Strucc = 0x06   
    EndIf                
    If ( SML_Struc == 7 )
        Strucc = 0x07   
    EndIf                
    If ( SML_Struc == 8 )
        Strucc = 0x08   
    EndIf                
    If ( SML_Struc == 9 )
        Strucc = 0x09   
    EndIf                



Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    ; skip if scenery density is lower than required
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall )
    Jump( ObjEnd )

Pcall:
    Perspective
    ; make it frame-rate friendly
    CondRefPoint( ObjReturn, 5800, 28, 0, 1, SML_Lat, SML_Lon, SML_Alt )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale)/100)*5
    ; this one has got crash-detection. Be aware!!! :-)
    GoIfOutCube( nocrash,  -18,  18,   0,  148,   -30,  30 )
    SetVar( Crash_Flag, 14 )

nocrash:
    Rotate( Dwg,  0, 0, SML_Heading )
        Return

Dwg:
    PointsList( 0, 31 )     
    Point(      0,       0,      12   )  ;0
    Point(      0,      36,     9.6   )  ;1
    Point(      0,      64,     7.6   )  ;2 
    Point(      0,      88,     5.6   )  ;3 
    Point(      0,      88,      56   )  ;4 
    Point(      0,      92,      51   )  ;5  
    Point(      0,      98,      12   )  ;6 
    Point(      0,     108,       4   )  ;7 
    Point(      0,     120,       4   )  ;8 
    Point(      0,     120,      48   )  ;9  
    Point(      0,     124,      44   )  ;10  
    Point(      0,     130,       8   )  ;11  
    Point(      0,     140,       2   )  ;12 
    Point(      0,     148,       0   )  ;13 
    Point(      0,       0,     -12   )  ;14
    Point(      0,      36,    -9.6   )  ;15
    Point(      0,      64,    -7.6   )  ;16 
    Point(      0,      88,    -5.6   )  ;17 
    Point(      0,      88,     -56   )  ;18 
    Point(      0,      92,     -51   )  ;19  
    Point(      0,      98,     -12   )  ;20 
    Point(      0,     108,      -4   )  ;21 
    Point(      0,     120,      -4   )  ;22 
    Point(      0,     120,     -48   )  ;23  
    Point(      0,     124,     -44   )  ;24  
    Point(      0,     130,      -8   )  ;25  
    Point(      0,     140,      -2   )  ;26 
    Point(     18,       0,      36   )  ;27
    Point(    -18,       0,      36   )  ;28
    Point(    -18,       0,     -36   )  ;29
    Point(     18,       0,     -36   )  ;30
        
    SurfaceColor(  0x28 )  
    Polygon_4( 30, 29, 28, 27 )

        ;sructure mtallique
    LineColor(  Strucc  )
        MoveToPoint(  0  )
        LineToPoint(  1  )
        LineToPoint(  2  )
        LineToPoint(  3  )
        LineToPoint(  4  )
        LineToPoint(  5  )
        LineToPoint(  6  )
        LineToPoint(  7  )
        LineToPoint(  8  )
        LineToPoint(  9  )
        LineToPoint( 10  )
        LineToPoint( 11  )
        LineToPoint( 12  )
        LineToPoint( 13  )
       
        MoveToPoint( 14  )
        LineToPoint( 15  )
        LineToPoint( 16  )
        LineToPoint( 17  )
        LineToPoint( 18  )      
        LineToPoint( 19  )      
        LineToPoint( 20  )      
        LineToPoint( 21  )      
        LineToPoint( 22  )      
        LineToPoint( 23  )      
        LineToPoint( 24  )      
        LineToPoint( 25  )      
        LineToPoint( 26  )      
        LineToPoint( 13  )      
                          
        MoveToPoint(  0  )      
        LineToPoint( 15  )      
        LineToPoint(  1  )      
        LineToPoint( 14  )      
                          
        MoveToPoint(  1  )      
        LineToPoint( 16  )      
        LineToPoint(  2  )      
        LineToPoint( 15  )      
                          
        MoveToPoint(  2  )      
        LineToPoint( 17  )      
        LineToPoint(  3  )      
        LineToPoint( 16  )      
                          
        MoveToPoint(  3  )      
        LineToPoint( 21  )      
        LineToPoint(  7  )      
        LineToPoint( 17  )      
                          
        MoveToPoint(  7  )      
        LineToPoint( 22  )      
        LineToPoint(  8  )      
        LineToPoint( 21  )      
                          
        MoveToPoint(  8  )      
        LineToPoint( 26  )      
        LineToPoint( 12  )      
        LineToPoint( 22  )      
                          
        MoveToPoint(  6  )      
        LineToPoint(  3  )      
                          
        MoveToPoint( 20  )      
        LineToPoint( 17  )      
                          
        MoveToPoint( 11  )      
        LineToPoint(  8  )      
                          
        MoveToPoint( 25  )      
        LineToPoint( 22  )      

        MoveToPoint(  3   )
        LineToPoint(  7   )
        MoveToPoint(  17  )
        LineToPoint(  21  )
        MoveToPoint(  8   )
        LineToPoint(  12  )
        MoveToPoint(  22  )
        LineToPoint(  26  )

    GoIfOut(  ObjReturn,  0x028C, 2, 4 )
    LineColor(   0x0F  )
        DottedLine(   0,   140,   2,   0,  148,   0,   3   )
        DottedLine(   0,   140,  -2,   0,  148,   0,   3   )

ObjReturn:
        Return

ObjEnd:
        ENDMACRO
