;! " Plane tree "
;? " Scale "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Altitude "=SML_Alt
;? " Required scenery density to show (1-4) "=SML_Comp 
;? " Is season change required (0-1) "=SML_Change

; Converted by Alessandro Antonini ( with permission )


MACRO _Platane

Local ObjEnd, Pcall1, Scall1, Automne, Ete, Printemps, Faces, ObjReturn, Dwg

Area( SML_Lat, SML_Lon,  9 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Jump( ObjEnd )

Pcall1:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (( SML_Scale * 100 ) / ( SML_Scale * SML_Scale ) / 100 ) * 5
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 0, 8 )
    Point(   -38,     0,    0 )  ;face
    Point(   -38,    81,    0 )
    Point(    32,    81,    0 )
    Point(    32,     0,    0 )

    Point(     0,     0,  -38 )  ;Profil
    Point(     0,    81,  -38 )
    Point(     0,    81,   32 )
    Point(     0,     0,   32 )
  
    GoIfOut( Automne, 0x6F8, 0, 2 )
    GoIfOut( Ete, 0x6F8, 0, 1 )
    GoIfOut( Printemps, 0x6F8, 0, 0 )

    If( SML_Change == 1 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - north hemisphere
    EndIf

    If( SML_Change == 0 )
        Texture( "AIRPT004", "OAV" ) ; summer - south hemisphere
    EndIf
    Jump( Faces )

Printemps:
    If( SML_Change == 1 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn - south hemisphere
    EndIf
    Jump( Faces )

Ete:
    If( SML_Change == 1 )
        Texture( "AIRPT004", "OAV" ) ; summer - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - south hemisphere
    EndIf
    Jump( Faces )

Automne:
    If( SML_Change == 1 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn -north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - south hemisphere
    EndIf
    Jump( Faces )

Faces:
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,    116,      1 ) 
        TexturePt(  1,    116,     82 )
        TexturePt(  2,    186,     82 )
        TexturePt(  3,    186,      1 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,    116,      1 )
        TexturePt(  5,    116,     82 )
        TexturePt(  6,    186,     82 )
        TexturePt(  7,    186,      1 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,    186,      1 )
        TexturePt(  2,    186,     82 )
        TexturePt(  1,    116,     82 )
        TexturePt(  0,    116,      1 )
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,    186,      1 )
        TexturePt(  6,    186,     82 )
        TexturePt(  5,    116,     82 )
        TexturePt(  4,    116,      1 )
    TransparentOff
    Return

Scall1:
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    PointsList( 0, 12 )
    Point( -25,      0,    0  );face
    Point( -38,     30,    0  )
    Point( -18,     81,    0  )
    Point(  13,     81,    0  )
    Point(  32,     46,    0  )
    Point(  26,      0,    0  )

    Point(   0,      0,  -25  );Profil
    Point(   0,     30,  -38  )
    Point(   0,     81,  -18  )
    Point(   0,     81,   13  )
    Point(   0,     46,   32  )
    Point(   0,      0,   26  )

    SurfaceColor( 0x18 ) 
    Polygon_6(  5,  4,  3,  2,  1,  0 )
    Polygon_6( 11, 10,  9,  8,  7,  6 )
    Polygon_6(  0,  1,  2,  3,  4,  5 )
    Polygon_6(  6,  7,  8,  9, 10, 11 )
    Return

ObjEnd:
    ENDMACRO
