;! " Textured 2-peaks mountain (BROAD.R8) "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
; By Alessandro Antonini


MACRO _Mnt12P

Local ObjEnd, ObjReturn, Dwg, Pcall, Scall, NoCrash, Exec, TType, TTypeExt

TType = "BROAD"
TTypeExt = "R8"

_Area( 0x0B, SML_Lat, SML_Lon, 160 km, ObjEnd )
    PerspectiveCall( Pcall )
    ShadowCall( Scall )
    Goto( ObjEnd )

Pcall:
    Perspective

Scall:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 1, 10 )
        Point(  -1160,    0,   32     )
        Point(   -680,    0,  680     )
        Point(   -250,    0,  730     )
        Point(   1040,    0,  240     )
        Point(   1240,    0, -390     )
        Point(    720,    0, -820     )
        Point(    -40,    0, -860     )
        Point(   -780,    0, -330     )
        Point(   -390,  370,  100     )
        Point(    380,  440, -100     )
    GoIfVector( NoCrash,  9,  2,  1  )
    GoIfVector( NoCrash,  9,  3,  2  )
    GoIfVector( NoCrash,  9, 10,  3  )
    GoIfVector( NoCrash, 10,  4,  3  )
    GoIfVector( NoCrash, 10,  5,  4  )
    GoIfVector( NoCrash, 10,  6,  5  )
    GoIfVector( NoCrash, 10,  7,  6  )
    GoIfVector( NoCrash, 10,  9,  7  )
    GoIfVector( NoCrash,  7,  9,  8  )
    GoIfVector( NoCrash,  8,  9,  1  )
    SetVar( 0x0284, 2 )


NoCrash:
    Call( Exec )
    Return

Exec:
    Texture( TType, TTypeExt )
    TextureSmoothOn

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  1,    8, 139 )
        TexturePt(  2,  130,  28 )
        TexturePt(  9,  213, 178 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  2,  51,   34 )
        TexturePt(  3,  181,  28 )
        TexturePt(  9,  144, 200 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  3,  164,  25 )
        TexturePt( 10,  214, 233 )
        TexturePt(  9,   48, 199 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  3,   23,  11 )
        TexturePt(  4,  202,  86 )
        TexturePt( 10,  103, 208 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  4,  170,  29 )
        TexturePt(  5,  252, 215 )
        TexturePt( 10,   86, 176 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  5,   54,  50 )
        TexturePt(  6,  210,  94 )
        TexturePt( 10,  118, 229 )

    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  6,  190, 201 )
        TexturePt(  7,   42, 220 )
        TexturePt( 10,  144,  47 )


    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  7,   85, 220 )
        TexturePt(  9,   35,  35 )
        TexturePt( 10,  193,  71 )


    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  8,   31, 152 )
        TexturePt(  9,  181,  50 )
        TexturePt(  7,  217, 229 )


    AdjustTexture
    TexturePolygon( 3 )
        TexturePt(  1,   29,  38 )
        TexturePt(  9,  199, 133 )
        TexturePt(  8,   59, 201 )

    TextureSmoothOff
    Return

ObjEnd:
    ENDMACRO
