;! " Helicopters landing zone (H) "
;? " Scale: "=SML_Scale
;? " Heading [HDG]: "=SML_Heading
;? " Scenery complexity required to show on (1-4): "=SML_Comp
; by Alessandro Antonini

MACRO _Hsign

Local ObjEnd, ObjReturn, Dwg, Pcall

Area( SML_Lat, SML_Lon, 8 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    Priority( Pcall, 0x025 ) ; make it higher than runways
    Goto( ObjEnd )

Pcall:
    CondRefPoint( ObjReturn, 5831, 28, 0, 1, SML_Lat, SML_Lon, 0 )
    _FS5SCALE = ((SML_Scale * 100) / (SML_Scale*SML_Scale)/100)*10
    Rotate( Dwg, 0, 0, SML_Heading )
    Return

Dwg:
    PointsList( 1, 18 )
    Point(    -30,    0,   -5 ) ; 1
    Point(     30,    0,   -5 ) ; 2
    Point(     30,    0,  -55 ) ; 3
    Point(     40,    0,  -55 ) ; 4
    Point(     40,    0,   55 ) ; 5
    Point(     30,    0,   55 ) ; 6
    Point(     30,    0,    5 ) ; 7
    Point(    -30,    0,    5 ) ; 8
    Point(    -30,    0,   55 ) ; 9
    Point(    -40,    0,   55 ) ; 10
    Point(    -40,    0,  -55 ) ; 11
    Point(    -30,    0,  -55 ) ; 12
    Point(   -182,    0, -105 ) ; 13
    Point(    182,    0, -105 ) ; 14
    Point(      0,    0,  210 ) ; 15
    Point(   -173,    0, -100 ) ; 16
    Point(    173,    0, -100 ) ; 17
    Point(      0,    0,  200 ) ; 18

    SurfaceColor( 0x09 )

    Concave
    StartSurface
        MoveToPoint(  1 )
        LineToPoint(  2 )
        LineToPoint(  3 )
        LineToPoint(  4 )
        LineToPoint(  5 )
        LineToPoint(  6 )
        LineToPoint(  7 )
        LineToPoint(  8 )
        LineToPoint(  9 )
        LineToPoint( 10 )
        LineToPoint( 11 )
        LineToPoint( 12 )
    CloseSurface

    Concave
    StartSurface
        MoveToPoint( 13 )
        LineToPoint( 14 )
        LineToPoint( 15 )
        LineToPoint( 18 )
        LineToPoint( 17 )
        LineToPoint( 16 )
    CloseSurface

    StartSurface
        MoveToPoint( 13 )
        LineToPoint( 15 )
        LineToPoint( 18 )
        LineToPoint( 16 )
    CloseSurface

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
