;! " 2 slopes roof hangar with fixed door"
;? " Scale: "=SML_Scale
;? " Heading [HDG] "=SML_Heading
;? " Walls Color: "=SML_Wall
;? " Roof  Color: "=SML_Roof
;? " Door  Color: "=SML_Door
;? " Scenery density required to show on (1-4): "=SML_Comp
; by Alessandro Antonini

MACRO _Hangar3F

Local ObjEnd, PCall, Scall, Dwg, ObjReturn, Ntest, Outer


Area( SML_Lat, SML_Lon, 20 km, ObjEnd ) 
     GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
     PerspectiveCall( PCall )
     ShadowCall( Scall )
     Jump( ObjEnd )

PCall:
    Perspective

Scall:    
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100
    Rotate( Dwg,  0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 0, 18 )
        Point(    -40,    0,   -30  ) ; 0           
        Point(    -40,   24,   -30  ) ; 1           
        Point(      0,   31,   -30  ) ; 2           
        Point(     40,   24,   -30  ) ; 3           
        Point(     40,    0,   -30  ) ; 4           
        Point(     30,    0,   -30  ) ; 5           
        Point(     30,   15,   -30  ) ; 6           
        Point(    -30,   15,   -30  ) ; 7           
        Point(    -30,    0,   -30  ) ; 8           
        Point(    -40,    0,    30  ) ; 9           
        Point(    -40,   24,    30  ) ; 10          
        Point(      0,   31,    30  ) ; 11          
        Point(     40,   24,    30  ) ; 12          
        Point(     40,    0,    30  ) ; 13          
        Point(    -29,    0,   -30  ) ; 14          
        Point(    -29,   16,   -30  ) ; 15          
        Point(     31,   16,   -30  ) ; 16          
        Point(     31,    0,   -30  ) ; 17          
    Call( Outer )
    Return


Outer:
    If ( SML_Wall == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If ( SML_Wall == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If ( SML_Wall == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If ( SML_Wall == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If ( SML_Wall == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If ( SML_Wall == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If ( SML_Wall == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If ( SML_Wall == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If ( SML_Wall == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If ( SML_Wall == 9 )
        SurfaceColor( 0x09 )
    EndIf
    Concave    
        Polygon_9(  0, 1, 2, 3, 4, 5, 6, 7, 8 ) ; Outside N and N top walls
        Polygon_5( 13, 12, 11, 10,  9 )         ; Outside S and S top walls
        Polygon_4(  0,  9, 10,  1 )             ; Outside E wall
        Polygon_4(  4,  3, 12, 13 )             ; Outside W wall

    If ( SML_Roof == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If ( SML_Roof == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If ( SML_Roof == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If ( SML_Roof == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If ( SML_Roof == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If ( SML_Roof == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If ( SML_Roof == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If ( SML_Roof == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If ( SML_Roof == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If ( SML_Roof == 9 )
        SurfaceColor( 0x09 )
    EndIf
        Polygon_4( 11,  2,  1, 10 )             ; Outside E roof
        Polygon_4(  3,  2, 11, 12 )             ; Outside W roof

    If ( SML_Door == 0 )
        SurfaceColor( 0x00 )
    EndIf
    If ( SML_Door == 1 )
        SurfaceColor( 0x01 )
    EndIf
    If ( SML_Door == 2 )
        SurfaceColor( 0x02 )
    EndIf
    If ( SML_Door == 3 )
        SurfaceColor( 0x03 )
    EndIf
    If ( SML_Door == 4 )
        SurfaceColor( 0x04 )
    EndIf
    If ( SML_Door == 5 )
        SurfaceColor( 0x05 )
    EndIf
    If ( SML_Door == 6 )
        SurfaceColor( 0x06 )
    EndIf
    If ( SML_Door == 7 )
        SurfaceColor( 0x07 )
    EndIf
    If ( SML_Door == 8 )
        SurfaceColor( 0x08 )
    EndIf
    If ( SML_Door == 9 )
        SurfaceColor( 0x09 )
    EndIf
        Polygon_4( 8, 7, 6, 5 )                 ; Door
    Concave
        Polygon_8( 14, 15, 16, 17, 5, 6, 7, 8 ) ; Frame door

    GoIfNot( Ntest, 0x28C, 6 )                ; Night lights
    GoIfVector( Ntest, 1, 2, 3 )
    LineColor( 0x16 )
        DottedLine( -40, 24, -30,   40, 24, -30,  5 )
    Return

Ntest:
    Return

ObjEnd:
    ENDMACRO

