;! " Textured brown/litebrown Hangar (adjustable) "
;? " Length: "=SML_Length
;? " Width: "=SML_Width
;? " Height: "=SML_Height
;? " Heading [HDG] "=SML_Heading
;? " Required scenery density to show on (1-4) "=SML_Comp
;? " Texture Smoothing (0-1) "=SML_Smooth

MACRO _CusHang5

Local ObjEnd, ObjReturn, Scall1, Pcall1, Dwg, Outer, Roof

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 1, 8 )
    Point(  -(SML_Width/2),              0,   -(SML_Length/2) ) ;1
    Point(  -(SML_Width/2),              0,    (SML_Length/2) ) ;2
    Point(   (SML_Width/2),              0,    (SML_Length/2) ) ;3
    Point(   (SML_Width/2),              0,   -(SML_Length/2) ) ;4
    Point(  -(SML_Width/2),   (SML_Height),   -(SML_Length/2) ) ;5
    Point(  -(SML_Width/2),   (SML_Height),    (SML_Length/2) ) ;6
    Point(   (SML_Width/2),   (SML_Height),    (SML_Length/2) ) ;7
    Point(   (SML_Width/2),   (SML_Height),   -(SML_Length/2) ) ;8
    Call( Outer )
    Call( Roof )
    Return
    

Outer:
    If ( Sml_Smooth == 1 )
        Texture( "a-obj-2", "r8" )
        TextureSmoothOn
    Else
        Texture( "a-obj-2", "r8" )
    EndIf        

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 1,  158,   98 )
        TexturePt( 2,    0,   98 )
        TexturePt( 6,    0,   77 )
        TexturePt( 5,  158,   77 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 2,  235,   98 )
        TexturePt( 3,  154,   98 )
        TexturePt( 7,  154,   77 )
        TexturePt( 6,  235,   77 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 3,  158,   98 )
        TexturePt( 4,    0,   98 )
        TexturePt( 8,    0,   77 )
        TexturePt( 7,  158,   77 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 4,  235,   98 )
        TexturePt( 1,  154,   98 )
        TexturePt( 5,  154,   77 )
        TexturePt( 8,  235,   77 )

    If ( Sml_Smooth == 1 )
        TextureSmoothOff
        Return
    Else
        Return
    EndIf        

    

Roof:
    SurfaceColor( LightGrey ) ; roof
    Polygon_4( 5, 6, 7, 8 )
    Return


ObjEnd:
    ENDMACRO
