;! " Textured grey/cyan Hangar (adjustable) "
;? " Length: "=SML_Length
;? " Width: "=SML_Width
;? " Height: "=SML_Height
;? " Heading [HDG] "=SML_Heading
;? " Required scenery density to show on (1-4) "=SML_Comp
;? " Texture Smoothing (0-1) "=SML_Smooth

MACRO _CusHang3

Local ObjEnd, ObjReturn, Scall1, Pcall1, Dwg, Outer, Roof

Area( SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall1 )
    ShadowCall( Scall1 )
    Jump( ObjEnd )

Pcall1:
    Perspective

Scall1:
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, 0 )
    Rotate( Dwg, 0, 0, SML_Heading )

ObjReturn:
    Return

Dwg:
    PointsList( 1, 8 )
    Point(  -(SML_Width/2),              0,   -(SML_Length/2) ) ;1
    Point(  -(SML_Width/2),              0,    (SML_Length/2) ) ;2
    Point(   (SML_Width/2),              0,    (SML_Length/2) ) ;3
    Point(   (SML_Width/2),              0,   -(SML_Length/2) ) ;4
    Point(  -(SML_Width/2),   (SML_Height),   -(SML_Length/2) ) ;5
    Point(  -(SML_Width/2),   (SML_Height),    (SML_Length/2) ) ;6
    Point(   (SML_Width/2),   (SML_Height),    (SML_Length/2) ) ;7
    Point(   (SML_Width/2),   (SML_Height),   -(SML_Length/2) ) ;8
    Call( Outer )
    Call( Roof )
    Return
    

Outer:
    If ( Sml_Smooth == 1 )
        Texture( "a-obj-2", "r8" )
        TextureSmoothOn
    Else
        Texture( "a-obj-2", "r8" )
    EndIf        
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 1,  142,   23 )
        TexturePt( 2,    0,   23 )
        TexturePt( 6,    0,    0 )
        TexturePt( 5,  142,    0 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 2,   70,   23 )
        TexturePt( 3,    0,   23 )
        TexturePt( 7,    0,    0 )
        TexturePt( 6,   70,    0 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 3,  142,   23 )
        TexturePt( 4,    0,   23 )
        TexturePt( 8,    0,    0 )
        TexturePt( 7,  142,    0 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt( 4,   70,   23 )
        TexturePt( 1,    0,   23 )
        TexturePt( 5,    0,    0 )
        TexturePt( 8,   70,    0 )
    If ( Sml_Smooth == 1 )
        TextureSmoothOff
        Return
    Else
        Return
    EndIf        

    

Roof:
    SurfaceColor( LightGrey ) ; roof
    Polygon_4( 5, 6, 7, 8 )
    Return


ObjEnd:
    ENDMACRO
