;! " Oak tree "
;? " Scale "=SML_Scale
;? " Heading "=SML_Heading
;? " Altitude "=SML_Alt
;? " Required scenery density to show (1-4) "=SML_Comp 
;? " Is season change required (0-1) "=SML_Change

; Converted by Alessandro Antonini ( with permission )


MACRO _Chene

Local ObjEnd, Pcall1, ombre, Automne, Ete, Printemps, Faces, ObjReturn

Area( SML_Lat, SML_Lon,  9 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( ombre )
    Jump( ObjEnd )

Pcall1:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100

    PointsList( 0, 19 )
    Point(   -37,     0,    0 )  ;face
    Point(   -37,    79,    0 )  ;1
    Point(    34,    79,    0 )  ;2
    Point(    34,     0,    0 )  ;3

    Point(     0,     0,  -37 )  ;Profil
    Point(     0,    79,  -37 )  ;5
    Point(     0,    79,   34 )  ;6
    Point(     0,     0,   34 )  ;7
; Shadow
    Point(   -24,     0,    0 )  ;8
    Point(   -38,    44,    0 )  ;9
    Point(   -19,    79,    0 )  ;10
    Point(    14,    79,    0 )  ;11
    Point(    34,    54,    0 )  ;12
    Point(    31,     0,    0 )  ;13
 
    Point(     0,     0,  -24 )  ;14
    Point(     0,    44,  -38 )  ;15
    Point(     0,    79,  -19 )  ;16
    Point(     0,    79,   14 )  ;17
    Point(     0,    54,   34 )  ;18
    Point(     0,     0,   31 )  ;19
  
    GoIfOut( Automne, 0x6F8, 0, 2 )
    GoIfOut( Ete, 0x6F8, 0, 1 )
    GoIfOut( Printemps, 0x6F8, 0, 0 )

    If( SML_Change == 1 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - north hemisphere
    EndIf

    If( SML_Change == 0 )
        Texture( "AIRPT004", "OAV" ) ; summer - south hemisphere
    EndIf
    Jump( Faces )

Printemps:
    If( SML_Change == 1 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn - south hemisphere
    EndIf
    Jump( Faces )

Ete:
    If( SML_Change == 1 )
        Texture( "AIRPT004", "OAV" ) ; summer - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - south hemisphere
    EndIf
    Jump( Faces )

Automne:
    If( SML_Change == 1 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn -north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - south hemisphere
    EndIf
    Jump( Faces )

Faces:
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,    104,     84 ) 
        TexturePt(  1,    104,    163 )
        TexturePt(  2,    176,    163 )
        TexturePt(  3,    176,     84 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,    105,     84 ) 
        TexturePt(  5,    105,    163 )
        TexturePt(  6,    176,    163 )
        TexturePt(  7,    176,     84 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,    104,     84 )
        TexturePt(  2,    104,    163 )
        TexturePt(  1,    176,    163 )
        TexturePt(  0,    176,     84 ) 
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,    176,     84 )
        TexturePt(  6,    176,    163 )
        TexturePt(  5,    105,    163 )
        TexturePt(  4,    105,     84 ) 
    TransparentOff
    Return

ombre:
    SurfaceColor( 0x18 ) 
    Polygon_6( 13, 12, 11, 10,  9,  8 )
    Polygon_6( 19, 18, 17, 16, 15, 14 )
    Polygon_6(  8,  9, 10, 11, 12, 13 )
    Polygon_6( 14, 15, 16, 17, 18, 19 )
    Return

ObjReturn:
    Return
ObjEnd:
ENDMACRO
