;! " Exhaust chimney "
;? " Scenery density required to show on (0-4): "=SML_Comp
;? " Color 1: "=SML_Colora
;? " Color 2: "=SML_Colorb
;? " Color 3: "=SML_Colorc
; converted by Alessandro Antonini, with permission from Airport author

MACRO _Chimney1

Local ObjEnd, Pcall, Scall, Dwg, ColorA, ColorB, ColorC, Chimney, Mid, Upper,
      NoWind, StrongWind, Smoke, ObjReturn
; setup defaults
ColorA = 0x04
ColorB = 0x05
ColorC = 0x01

If ( SML_Colora == 0 )
    ColorA = 0x00
EndIf
If ( SML_Colora == 1 )
    ColorA = 0x01
EndIf
If ( SML_Colora == 2 )
    ColorA = 0x02
EndIf
If ( SML_Colora == 3 )
    ColorA = 0x03
EndIf
If ( SML_Colora == 4 )
    ColorA = 0x04
EndIf
If ( SML_Colora == 5 )
    ColorA = 0x05
EndIf
If ( SML_Colora == 6 )
    ColorA = 0x06
EndIf
If ( SML_Colora == 7 )
    ColorA = 0x07
EndIf
If ( SML_Colora == 8 )
    ColorA = 0x08
EndIf
If ( SML_Colora == 9 )
    ColorA = 0x09
EndIf

If ( SML_Colorb == 0 )
    ColorB = 0x00
EndIf
If ( SML_Colorb == 1 )
    ColorB = 0x01
EndIf
If ( SML_Colorb == 2 )
    ColorB = 0x02
EndIf
If ( SML_Colorb == 3 )
    ColorB = 0x03
EndIf
If ( SML_Colorb == 4 )
    ColorB = 0x04
EndIf
If ( SML_Colorb == 5 )
    ColorB = 0x05
EndIf
If ( SML_Colorb == 6 )
    ColorB = 0x06
EndIf
If ( SML_Colorb == 7 )
    ColorB = 0x07
EndIf
If ( SML_Colorb == 8 )
    ColorB = 0x08
EndIf
If ( SML_Colorb == 9 )
    ColorB = 0x09
EndIf

If ( SML_Colorc == 0 )
    ColorC = 0x00
EndIf
If ( SML_Colorc == 1 )
    ColorC = 0x01
EndIf
If ( SML_Colorc == 2 )
    ColorC = 0x02
EndIf
If ( SML_Colorc == 3 )
    ColorC = 0x03
EndIf
If ( SML_Colorc == 4 )
    ColorC = 0x04
EndIf
If ( SML_Colorc == 5 )
    ColorC = 0x05
EndIf
If ( SML_Colorc == 6 )
    ColorC = 0x06
EndIf
If ( SML_Colorc == 7 )
    ColorC = 0x07
EndIf
If ( SML_Colorc == 8 )
    ColorC = 0x08
EndIf
If ( SML_Colorc == 9 )
    ColorC = 0x09
EndIf

Area(  SML_Lat, SML_Lon, 22 km, ObjEnd )
    GoIfOut(  ObjEnd,  0x0346, SML_Comp,  4  ) 
    PerspectiveCall( Pcall )
    ShadowCall( Scall )        
    Jump( ObjEnd )

Pcall:
    Perspective
        
Scall:        
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 0.25, 0 )
    _FS5SCALE = 1.25
    Call( Dwg )
    IndirectRotate( Smoke, 0, 0, 0, 0, 0, 0, 0, 0, Wind_layer_0_dir )
    Return

Dwg:
    PointsListVect(  0, 16 )
        PointVect(  15,     0,     0  ) ; 0
        PointVect(  14,     0,     6  ) ; 1
        PointVect(  11,     0,    10  ) ; 2
        PointVect(   6,     0,    14  ) ; 3
        PointVect(   0,     0,    15  ) ; 4
        PointVect(  -6,     0,    14  ) ; 5
        PointVect( -11,     0,    10  ) ; 6
        PointVect( -14,     0,     6  ) ; 7
        PointVect( -15,     0,     0  ) ; 8
        PointVect( -14,     0,    -6  ) ; 9
        PointVect( -11,     0,   -10  ) ; 10
        PointVect(  -6,     0,   -14  ) ; 11
        PointVect(   0,     0,   -15  ) ; 12
        PointVect(   6,     0,   -14  ) ; 13
        PointVect(  11,     0,   -10  ) ; 14
        PointVect(  14,     0,    -6  ) ; 15
                                           
    PointsListVect( 20, 16 )
        PointVect(  10,   250,     0  ) ; 20 
        PointVect(   9,   250,     4  ) ; 21 
        PointVect(   7,   250,     7  ) ; 22 
        PointVect(   4,   250,     9  ) ; 23 
        PointVect(   0,   250,    10  ) ; 24 
        PointVect(  -4,   250,     9  ) ; 25 
        PointVect(  -7,   250,     7  ) ; 26 
        PointVect(  -9,   250,     4  ) ; 27 
        PointVect( -10,   250,     0  ) ; 28 
        PointVect(  -9,   250,    -4  ) ; 29 
        PointVect(  -7,   250,    -7  ) ; 30
        PointVect(  -4,   250,    -9  ) ; 31
        PointVect(   0,   250,   -10  ) ; 32
        PointVect(   4,   250,    -9  ) ; 33
        PointVect(   7,   250,    -7  ) ; 34
        PointVect(   9,   250,    -4  ) ; 35

    PointsListVect( 40, 16 )
        PointVect(  10,   260,     0  ) ; 40
        PointVect(   9,   260,     4  ) ; 41
        PointVect(   7,   260,     7  ) ; 42
        PointVect(   4,   260,     9  ) ; 43
        PointVect(   0,   260,    10  ) ; 44
        PointVect(  -4,   260,     9  ) ; 45
        PointVect(  -7,   260,     7  ) ; 46
        PointVect(  -9,   260,     4  ) ; 47
        PointVect( -10,   260,     0  ) ; 48
        PointVect(  -9,   260,    -4  ) ; 49
        PointVect(  -7,   260,    -7  ) ; 50
        PointVect(  -4,   260,    -9  ) ; 51
        PointVect(   0,   260,   -10  ) ; 52
        PointVect(   4,   260,    -9  ) ; 53
        PointVect(   7,   260,    -7  ) ; 54
        PointVect(   9,   260,    -4  ) ; 55

Chimney:
    GradColor(  ColorA  )
        GradPolygon_4(  20, 21,  1,  0  )
        GradPolygon_4(  21, 22,  2,  1  )
        GradPolygon_4(  22, 23,  3,  2  )
        GradPolygon_4(  23, 24,  4,  3  )
        GradPolygon_4(  24, 25,  5,  4  )
        GradPolygon_4(  25, 26,  6,  5  )
        GradPolygon_4(  26, 27,  7,  6  )
        GradPolygon_4(  27, 28,  8,  7  )
        GradPolygon_4(  28, 29,  9,  8  )
        GradPolygon_4(  29, 30, 10,  9  )
        GradPolygon_4(  30, 31, 11, 10  )
        GradPolygon_4(  31, 32, 12, 11  )
        GradPolygon_4(  32, 33, 13, 12  )
        GradPolygon_4(  33, 34, 14, 13  )
        GradPolygon_4(  34, 35, 15, 14  )
        GradPolygon_4(  35, 20,  0, 15  )
        
      
Mid:
    GradColor(  ColorB  )
        GradPolygon_4(  40, 41, 21, 20  ) 
        GradPolygon_4(  41, 42, 22, 21  )
        GradPolygon_4(  42, 43, 23, 22  ) 
        GradPolygon_4(  43, 44, 24, 23  )
        GradPolygon_4(  44, 45, 25, 24  )
        GradPolygon_4(  45, 46, 26, 25  )
        GradPolygon_4(  46, 47, 27, 26  )
        GradPolygon_4(  47, 48, 28, 27  )
        GradPolygon_4(  48, 49, 29, 28  )
        GradPolygon_4(  49, 50, 30, 29  )
        GradPolygon_4(  50, 51, 31, 30  )
        GradPolygon_4(  51, 52, 32, 31  )
        GradPolygon_4(  52, 53, 33, 32  )
        GradPolygon_4(  53, 54, 34, 33  )
        GradPolygon_4(  54, 55, 35, 34  )
        GradPolygon_4(  55, 40, 20, 35  )
        

Upper:
    SurfaceColor(  ColorC  )
    Concave
        Polygon_16( 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 
                    42, 41, 40 )

    Return


Smoke:
    PointsList(  60, 8 )
        Point(    0,   260,    13  ) ; 60
        Point(    0,   280,     0  ) ; 61 
        Point(    0,   290,   -70  ) ; 62   
        Point(    0,   330,  -140  ) ; 63
        Point(    0,   330,  -150  ) ; 64
        Point(    0,   300,  -150  ) ; 65 
        Point(    0,   265,   -80  ) ; 66   
        Point(    0,   260,   -15  ) ; 67
         
    PointsList(  70, 8 )   
        Point(    0,   262,    13  ) ; 70
        Point(    0,   280,    20  ) ; 71
        Point(    0,   380,    25  ) ; 72
        Point(    0,   450,     0  ) ; 73
        Point(    0,   480,   -30  ) ; 74
        Point(    0,   385,   -25  ) ; 75
        Point(    0,   350,   -20  ) ; 76
        Point(    0,   262,   -15  ) ; 77
      

NoWind:
    GoIfOut( StrongWind, 0xC72,  0,  2 )
    Texture( "airpt003", "oav" )
    TransparentOn
    AdjustTexture
    TexturePolygon( 8 )
       TexturePt(  71,   92,  144  )
       TexturePt(  70,   75,  111  )
       TexturePt(  77,  125,  111  )
       TexturePt(  76,  199,  121  )
       TexturePt(  75,  240,  148  )
       TexturePt(  74,  255,  174  )
       TexturePt(  73,  225,  179  )
       TexturePt(  72,  165,  153  )
    AdjustTexture
    TexturePolygon( 8 )
       TexturePt(  70,   75,  111  )
       TexturePt(  71,   92,  144  )
       TexturePt(  72,  165,  153  )
       TexturePt(  73,  225,  179  )
       TexturePt(  74,  255,  174  )
       TexturePt(  75,  240,  148  )
       TexturePt(  76,  199,  121  )
       TexturePt(  77,  125,  111  )
    TransparentOff
    Return


StrongWind:
    Texture( "airpt003", "oav" )
    TransparentOn
    AdjustTexture
    TexturePolygon( 8 )
       TexturePt(  67,  125,  111  )
       TexturePt(  66,  199,  121  )
       TexturePt(  65,  240,  148  )
       TexturePt(  64,  255,  174  )
       TexturePt(  63,  225,  179  )
       TexturePt(  62,  165,  153  )
       TexturePt(  61,   92,  144  )
       TexturePt(  60,   75,  111  )
    AdjustTexture
    TexturePolygon( 8 )
       TexturePt(  60,   75,  111  )
       TexturePt(  61,   92,  144  )
       TexturePt(  62,  165,  153  )
       TexturePt(  63,  225,  179  )
       TexturePt(  64,  255,  174  )
       TexturePt(  65,  240,  148  )
       TexturePt(  66,  199,  121  )
       TexturePt(  67,  125,  111  )
    TransparentOff
    Return

ObjReturn:
    Return

ObjEnd:
    ENDMACRO
