;! " Hornbeam tree "
;? " Scale "=SML_Scale
;? " Heading "=SML_Heading
;? " Altitude "=SML_Alt
;? " Required scenery density to show (1-4) "=SML_Comp 
;? " Is season change required (0-1) "=SML_Change

; Converted by Alessandro Antonini ( with permission )


MACRO _Charme

Local ObjEnd, Pcall1, ombre, Automne, Ete, Printemps, Faces, ObjReturn

Area( SML_Lat, SML_Lon,  9 km, ObjEnd )
    GoIfOut(  ObjEnd, 0x0346, SML_Comp, 4 ) 
    PerspectiveCall( Pcall1 )
    ShadowCall( ombre )
    Jump( ObjEnd )

Pcall1:
    Perspective
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    _FS5SCALE = (SML_Scale * 100) / (SML_Scale*SML_Scale)/100

    PointsList( 0, 8 )
    Point(   -18,     0,    0 )  ;face
    Point(   -18,    52,    0 )
    Point(    18,    52,    0 )
    Point(    18,     0,    0 )

    Point(     0,     0,  -18 )  ;Profil
    Point(     0,    52,  -18 )
    Point(     0,    52,   18 )
    Point(     0,     0,   18 )
  
    GoIfOut( Automne, 0x6F8, 0, 2 )
    GoIfOut( Ete, 0x6F8, 0, 1 )
    GoIfOut( Printemps, 0x6F8, 0, 0 )

    If( SML_Change == 1 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - north hemisphere
    EndIf

    If( SML_Change == 0 )
        Texture( "AIRPT004", "OAV" ) ; summer - south hemisphere
    EndIf
    Jump( Faces )

Printemps:
    If( SML_Change == 1 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn - south hemisphere
    EndIf
    Jump( Faces )

Ete:
    If( SML_Change == 1 )
        Texture( "AIRPT004", "OAV" ) ; summer - north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0W4", "OAV" ) ; winter - south hemisphere
    EndIf
    Jump( Faces )

Automne:
    If( SML_Change == 1 )
        Texture( "AIRPT0A4", "OAV" ) ; autumn -north hemisphere
    EndIf
    If( SML_Change == 0 )
        Texture( "AIRPT0P4", "OAV" ) ; spring - south hemisphere
    EndIf
    Jump( Faces )

Faces:
    TransparentOn
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  0,    178,     85 ) 
        TexturePt(  1,    178,    166 )
        TexturePt(  2,    255,    166 )
        TexturePt(  3,    255,     85 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  4,    178,     85 )
        TexturePt(  5,    178,    166 )
        TexturePt(  6,    255,    166 )
        TexturePt(  7,    255,     85 )

    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  3,    255,     85 )
        TexturePt(  2,    255,    166 )
        TexturePt(  1,    178,    166 )
        TexturePt(  0,    178,     85 )
           
    AdjustTexture
    TexturePolygon( 4 )
        TexturePt(  7,    255,     85 )
        TexturePt(  6,    255,    166 )
        TexturePt(  5,    178,    166 )
        TexturePt(  4,    178,     85 )
    TransparentOff
    Return

ombre:
    ReferencePoint(  SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    PointsList( 0, 14 )
    Point(  -4,      0,    0  );face
    Point( -18,     18,    0  )
    Point( -12,     45,    0  )
    Point(   0,     52,    0  )
    Point(  17,     34,    0  )
    Point(  18,     13,    0  )
    Point(   3,      0,    0  )

    Point(   0,      0,   -4  );Profil
    Point(   0,     18,  -18  )
    Point(   0,     45,  -12  )
    Point(   0,     52,    0  )
    Point(   0,     34,   17  )
    Point(   0,     13,   18  )
    Point(   0,      0,    3  )

    SurfaceColor( 0x18 ) 
    Polygon_7(  6,  5,  4,  3,  2,  1,  0 )
    Polygon_7( 13, 12, 11, 10,  9,  8,  7 )
    Polygon_7(  0,  1,  2,  3,  4,  5,  6 )
    Polygon_7(  7,  8,  9, 10, 11, 12, 13 )
    Return

ObjReturn:
    Return
ObjEnd:
ENDMACRO
