;! " Adjustable altitude antenna (fixed scale)"
;? " Altitude: "=SML_Alt
;? " Scenery density required to show on (1-4): "=SML_Comp
; converted by A. Antonini ( with permission )

MACRO _Anten4
Local ObjEnd, ObjReturn, Pcall, Night, Flash, Dwg

Area(  SML_Lat, SML_Lon, 18 km, ObjEnd )
    GoIfOut( ObjEnd, 0x0346, SML_Comp, 4 )
    PerspectiveCall( Pcall )
    Jump( ObjEnd )           

Pcall:
    Perspective
    ReferencePoint( SML_Lat, SML_Lon, ObjReturn, 1, SML_Alt )
    Rotate( Dwg, 0, 0, SML_Heading ) 

ObjReturn:        
    Return

Dwg:
    PointsList( 0, 46 )
    Point(     -1,    0,   -1    )         ; 0
    Point(     -1,    0,    1    )         ; 1
    Point(      1,    0,    1    )         ; 2
    Point(      1,    0,   -1    )         ; 3
    Point(     -1,    5,   -1    )         ; 4
    Point(     -1,    5,    1    )         ; 5
    Point(      1,    5,    1    )         ; 6
    Point(      1,    5,   -1    )         ; 7
    Point(     -1,   10,   -1    )         ; 8
    Point(     -1,   10,    1    )         ; 9
    Point(      1,   10,    1    )         ; 10
    Point(      1,   10,   -1    )         ; 11
    Point(     -1,   15,   -1    )         ; 12
    Point(     -1,   15,    1    )         ; 13
    Point(      1,   15,    1    )         ; 14
    Point(      1,   15,   -1    )         ; 15
    Point(     -1,   20,   -1    )         ; 16
    Point(     -1,   20,    1    )         ; 17
    Point(      1,   20,    1    )         ; 18
    Point(      1,   20,   -1    )         ; 19
    Point(     -1,   25,   -1    )         ; 20
    Point(     -1,   25,    1    )         ; 21
    Point(      1,   25,    1    )         ; 22
    Point(      1,   25,   -1    )         ; 23
    Point(      1,   20,   -3    )         ; 24
    Point(     -1,   20,   -3    )         ; 25
    Point(      3,   20,   -3    )         ; 26
    Point(     -3,   20,   -3    )         ; 27
    Point(      3,   21,   -3    )         ; 28
    Point(      3,   19,   -3    )         ; 29
    Point(     -3,   21,   -3    )         ; 30
    Point(     -3,   19,   -3    )         ; 31
    Point(      2,   21,   -3    )         ; 32
    Point(      2,   19,   -3    )         ; 33
    Point(     -2,   21,   -3    )         ; 34
    Point(     -2,   19,   -3    )         ; 35
    Point(      1,   21,   -3    )         ; 36
    Point(      1,   19,   -3    )         ; 37
    Point(     -1,   21,   -3    )         ; 38
    Point(     -1,   19,   -3    )         ; 39
    Point(     -2,   10,   -1    )         ; 40
    Point(     -2,   10,    1    )         ; 41
    Point(     -2,   16,    1    )         ; 42
    Point(     -2,   18,   -1    )         ; 43
    Point(      0,   21,   -3    )         ; 44
    Point(      0,   19,   -3    )         ; 45

    LineColor( 0x04 )  ; Element 1
        MoveToPoint(   0 )
        LineToPoint(   1 )
        LineToPoint(   2 )
        LineToPoint(   3 )
        LineToPoint(   7 )
        LineToPoint(   4 )
        LineToPoint(   5 )
        LineToPoint(   6 )
        LineToPoint(   7 )
        MoveToPoint(   0 )
        LineToPoint(   4 )
        MoveToPoint(   1 )
        LineToPoint(   5 )
        MoveToPoint(   2 )
        LineToPoint(   6 )
        MoveToPoint(   0 )
        LineToPoint(   7 )
        LineToPoint(   2 )
        LineToPoint(   5 )
        LineToPoint(   0 )
        MoveToPoint(   3 )
        LineToPoint(   4 )
        LineToPoint(   7 )
        LineToPoint(   6 )
        LineToPoint(   3 )
    LineColor( 0x05 )  ; Element 2
        MoveToPoint(   4 )  
        LineToPoint(   5 ) 
        LineToPoint(   6 ) 
        LineToPoint(   7 ) 
        LineToPoint(  11 )
        LineToPoint(   8 ) 
        LineToPoint(   9 ) 
        LineToPoint(  10 )
        LineToPoint(  11 )
        MoveToPoint(   4 ) 
        LineToPoint(   8 ) 
        MoveToPoint(   5 ) 
        LineToPoint(   9 ) 
        MoveToPoint(   6 ) 
        LineToPoint(  10 )
        MoveToPoint(   4 ) 
        LineToPoint(  11 )
        LineToPoint(   6 ) 
        LineToPoint(   9 ) 
        LineToPoint(   4 ) 
        MoveToPoint(   7 ) 
        LineToPoint(   8 ) 
        LineToPoint(  11 )
        LineToPoint(  10 )
        LineToPoint(   7 ) 
    LineColor( 0x04 )  ; Element 3
        MoveToPoint(   8 )   
        LineToPoint(   9 )  
        LineToPoint(  10 ) 
        LineToPoint(  11 ) 
        LineToPoint(  15 ) 
        LineToPoint(  12 ) 
        LineToPoint(  13 ) 
        LineToPoint(  14 ) 
        LineToPoint(  15 ) 
        MoveToPoint(   8 )  
        LineToPoint(  12 ) 
        MoveToPoint(   9 )  
        LineToPoint(  13 ) 
        MoveToPoint(  10 ) 
        LineToPoint(  14 ) 
        MoveToPoint(   8 )  
        LineToPoint(  15 ) 
        LineToPoint(  10 ) 
        LineToPoint(  13 ) 
        LineToPoint(   8 )  
        MoveToPoint(  11 ) 
        LineToPoint(  12 ) 
        LineToPoint(  15 ) 
        LineToPoint(  14 ) 
        LineToPoint(  11 ) 
    LineColor( 0x05 )  ; Element 4
        MoveToPoint(  12 ) 
        LineToPoint(  13 ) 
        LineToPoint(  14 ) 
        LineToPoint(  15 ) 
        LineToPoint(  19 ) 
        LineToPoint(  16 ) 
        LineToPoint(  17 ) 
        LineToPoint(  18 ) 
        LineToPoint(  19 ) 
        MoveToPoint(  12 ) 
        LineToPoint(  16 ) 
        MoveToPoint(  13 ) 
        LineToPoint(  17 ) 
        MoveToPoint(  14 ) 
        LineToPoint(  18 ) 
        MoveToPoint(  12 ) 
        LineToPoint(  19 ) 
        LineToPoint(  14 ) 
        LineToPoint(  17 ) 
        LineToPoint(  12 ) 
        MoveToPoint(  15 ) 
        LineToPoint(  16 ) 
        LineToPoint(  19 ) 
        LineToPoint(  18 ) 
        LineToPoint(  15 ) 
    LineColor( 0x04 )  ; Element 5
        MoveToPoint(  16 )
        LineToPoint(  17 )
        LineToPoint(  18 )
        LineToPoint(  19 )
        LineToPoint(  23 )
        LineToPoint(  20 )
        LineToPoint(  21 )
        LineToPoint(  22 )
        LineToPoint(  23 )
        MoveToPoint(  16 )
        LineToPoint(  20 )
        MoveToPoint(  17 )
        LineToPoint(  21 )
        MoveToPoint(  18 )
        LineToPoint(  22 )
        MoveToPoint(  16 )
        LineToPoint(  23 )
        LineToPoint(  18 )
        LineToPoint(  21 )
        LineToPoint(  16 )
        MoveToPoint(  19 )
        LineToPoint(  20 )
        LineToPoint(  23 )
        LineToPoint(  22 )
        LineToPoint(  19 )
    LineColor( 0x00 )  ; Bras antenne 1
        MoveToPoint(  19 )
        LineToPoint(  24 )
    LineColor( 0x00 )  ; Bras antenne 2
        MoveToPoint(  16 )
        LineToPoint(  25 )
    LineColor( 0x02 )  ; antenne 1
        MoveToPoint(  26 )
        LineToPoint(  27 )
    LineColor( 0x02 )  ; antenne 2
        MoveToPoint(  28 )
        LineToPoint(  29 )
    LineColor( 0x02 )  ; antenne 3
        MoveToPoint(  30 )
        LineToPoint(  31 )
    LineColor( 0x02 )  ; antenne 4
        MoveToPoint(  32 )
        LineToPoint(  33 )
    LineColor( 0x02 )  ; antenne 5
        MoveToPoint(  34 )
        LineToPoint(  35 )
    LineColor( 0x02 )  ; antenne 6
        MoveToPoint(  36 )
        LineToPoint(  37 )
    LineColor( 0x02 )  ; antenne 7
        MoveToPoint(  38 )
        LineToPoint(  39 )
    LineColor( 0x02 )  ; antenne 8
        MoveToPoint(  44 )
        LineToPoint(  45 )
    LineColor( 0x00 )  ; Bras antenne 3
        MoveToPoint(   8 )
        LineToPoint(  40 )
    LineColor( 0x00 )  ; Bras antenne 4
        MoveToPoint(   9 )
        LineToPoint(  41 )
    LineColor( 0x01 )  ; grande antenne 1
        MoveToPoint(  41 )
        LineToPoint(  42 )
    LineColor( 0x02 )  ; grande antenne 2
        MoveToPoint(  40 )
        LineToPoint(  43 )

    GoIfNot( Flash, 0x28C, 6 )         ; Flash lights
    GoIfNot( Flash, 0x282, 3 )
    LineColor( 0x0F )
        DotToPoint(  21 )
        DotToPoint(  23 )
        DotToPoint(  24 )
Flash:
     Return

ObjEnd:
    ENDMACRO
