#include <dos.h>
#include <iostream.h>
#include <stdlib.h>

#include "..\..\lib\debug\jptui.h"
//#include "jptui.h"

#define VERSION     3
#define SUB_VERSION 6


#define VOC_LANGUAGE 1000
#define VOC_HELLO    1001

//-- APPLICATION ------------------------------------------------------------

TApplication  JPTuiDemo(ENGLISH);

//-- MAIN WINDOW ------------------------------------------------------------

TWindow       MainWindow          (DIALOG1,
				   2,2,77,22,
				   "JPTUI Demo",
				   INFO_BAR,
				   NOT_MODAL);

TPushButton   QuitButton          (&MainWindow,
				   33,19,10,
				   "~Quit",
				   PB_CANCEL);

//-- MENUS ------------------------------------------------------------------

TMenuBar      MenuBar             (&MainWindow);

TMenuItem     MenuItemsMenuItems[]=

				  { {"~Unchecked item",
				     LI_TOGGLE,
				     SC_CTRL_F1,
				     "Help about 'Unchecked item' : it's a toggle"},

				    {"~Checked item",
				     LI_CHECKED,
				     SC_ALT_F1,
				     "Help about 'Checked item' : it's not a toggle"},

				    {SEPARATOR,
				     LI_NOATTR,
				     SC_NONE,
				     ""},

				    {"Disabled ~item",
				     LI_TOGGLE|LI_CHECKED|LI_DISABLED,
				     SC_SHIFT_F1,
				     "Help about 'Disabled item'"},

				    {NULL,
				     LI_NOATTR,
				     SC_NONE,
				     ""} };

TMenu	      MenuItemsMenu       (&MenuBar,
				   "~Menu_items",
				   MenuItemsMenuItems);


TMenuItem     DialogBoxesMenuItems[]=

				  { {"~Message Box",
				     LI_NOATTR,
				     SC_CTRL_BACKSPACE,
				     "This menu item opens two message boxes"},

				    {"~Input Box",
				     LI_NOATTR,
				     SC_CTRL_HOME,
				     "This menu item opens an input box"},

				    {SEPARATOR,
				     LI_NOATTR,
				     SC_NONE,
				     ""},

				    {"~File Selection Box",
				     LI_NOATTR,
				     SC_F3,
				     "This menu item opens a file selection box"},

				    {NULL,
				     LI_NOATTR,
				     SC_NONE,
				     ""} };

TMenu	      DialogBoxesMenu	  (&MenuBar,
				   "Dialo~g",
				   DialogBoxesMenuItems);


TMenuItem     OptionMenuItems[]=
				  { {"~Graphical pointer",
				     LI_TOGGLE|LI_CHECKED,
				     SC_CTRL_G,
				     "Select this item to choose the graphical mouse pointer"},

				    {SEPARATOR,
				     LI_NOATTR,
				     SC_NONE,
				     ""},

				    {"Text mode 80x25, 8 pixels per character",
				     LI_NOATTR,
				     SC_ALT_1,
				     "Sets the text mode to 80x25 with a 8-pixel-wide font"},

				    {"Text mode 80x25, 9 pixels per character",
				     LI_NOATTR|LI_CHECKED,
				     SC_ALT_2,
				     "Sets the text mode to 80x25 with a 9-pixel-wide font"},

				    {"Text mode 80x28, 8 pixels per character",
				     LI_NOATTR,
				     SC_ALT_3,
				     "Sets the text mode to 80x28 with a 8-pixel-wide font"},

				    {"Text mode 80x28, 8 pixels per character",
				     LI_NOATTR,
				     SC_ALT_4,
				     "Sets the text mode to 80x28 with a 9-pixel-wide font"},

				    {"Text mode 80x50, 8 pixels per character",
				     LI_NOATTR,
				     SC_ALT_5,
				     "Sets the text mode to 80x50 with a 8-pixel-wide font"},

				    {"Text mode 80x50, 9 pixels per character",
				     LI_NOATTR,
				     SC_ALT_6,
				     "Sets the text mode to 80x50 with a 9-pixel-wide font"},

				    {"Text mode 132x25 (Cirrus Logic only)" ,
				     LI_NOATTR,
				     SC_ALT_7,
				     "Sets the text mode to 132x25 (use only with a Cirrus Logic card)"},

				    {"Text mode 132x43 (Cirrus Logic only)" ,
				     LI_NOATTR,
				     SC_ALT_8,
				     "Sets the text mode to 132x43 (use only with a Cirrus Logic card)"},

				    {SEPARATOR,
				     LI_NOATTR,
				     SC_NONE,
				     ""},

				    {"Shows available memory",
				     LI_TOGGLE,
				     SC_NONE,
				     "Select this item to display free memory (only possible in debug version)"},

				    {NULL,
				     LI_NOATTR,
				     SC_NONE,
				     ""}  };

TMenu         OptionMenu          (&MenuBar,
				   "~Options",
				   OptionMenuItems);


TMenuItem     LanguageMenuItems[]={ {"Multi-~language support",
				     LI_NOATTR,
				     SC_CTRL_L,
				     "This menu item starts a demonstration of multi-language support"},

				    {NULL,
				     LI_NOATTR,
				     SC_NONE,
				     ""}  };

TMenu         LanguageMenu        (&MenuBar,
				   "La~nguage",
				   LanguageMenuItems);

TMenuItem     HelpMenuItems[]=
				  { {"~Help",
				     LI_NOATTR,
				     SC_F1,
				     "This menu item opens two modeless help windows"},

				    {NULL,
				     LI_NOATTR,
				     SC_NONE,
				     ""}  };

TMenu         HelpMenu	          (&MenuBar,
				   "~Help",
				   HelpMenuItems);

//-- TAB GROUP --------------------------------------------------------------

TTabGroup     TabGroup            (&MainWindow,
				   2,3,72,15,DIALOG2);
//-- BUTTONS ----------------------------------------------------------------

TTab	      ButtonTab	          (&TabGroup,
				   "B~uttons");

TLabel        PushButtonLabel     (&ButtonTab,
				   4,3,
				   "Push Button                              :");

TPushButton   PushButton          (&ButtonTab,
				   50,3,17,
				   "Push Button ~w");

TLabel        CancelPushButtonLabel
				  (&ButtonTab,
				   4,5,
				   "Cancel Push Button (pushed by <esc>)     :  Try Quit button below");

TLabel        DefaultPushButtonLabel
				  (&ButtonTab,
				   4,7,
				   "Default Push Button (pushed by <return>  :\nwhen no other button has the focus)");

TPushButton   DefaultPushButton   (&ButtonTab,
				   50,7,17,
				   "Push Button ~y",
				   PB_DEFAULT);

TLabel        DisabledPushButtonLabel
				  (&ButtonTab,
				   4,10,
				   "Disabled Push Button                     :");

TPushButton   DisabledPushButton  (&ButtonTab,
				   50,10,17,
				   "Push Button ~z",
				   PB_NORMAL,
				   DISABLED);


//-- CHECK BOXES ------------------------------------------------------------

TTab	      CheckBoxTab	  (&TabGroup,
				   "C~heck Boxes");

TCheckBox     CheckBox1		  (&CheckBoxTab,
				   8,4,20,
				   "Check Box ~1");

TCheckBox     CheckBox2		  (&CheckBoxTab,
				   8,5,20,
				   "Check Box ~2",
				   CHECKED);

TCheckBox     CheckBox3		  (&CheckBoxTab,
				   8,7,20,
				   "Check Box ~3",
				   NOT_CHECKED,
				   DISABLED);

TRadioGroup   RadioGroup          (&CheckBoxTab,
				   42,2,20,8,"~Radio Buttons");

TRadioButton  RadioButton1	  (&RadioGroup,
				   1,2,17,
				   "Radio Button ~x");

TRadioButton  RadioButton2	  (&RadioGroup,
				   1,3,17,
				   "Radio Button ~y",
				   CHECKED);


TRadioButton  RadioButton3	  (&RadioGroup,
				   1,5,17,
				   "Radio Button ~z",
				   NOT_CHECKED,
				   DISABLED);

//-- EDIT ZONES -------------------------------------------------------------

TTab	      EditZoneTab	  (&TabGroup,
				   "~Edit Zones");

TEditZone     EditZone     	  (&EditZoneTab,
				   42,1,
				   -40,0,
				   "Edit ~Zone (enter any string) :",
				   25,255,
				   "Enter a long string");

TEditZone     DisabledEditZone    (&EditZoneTab,
				   42,2,
				   -40,0,
				   "Di~sabled Edit Zone           :",
				   25,255,
				   "You can't enter anything",
				   DISABLED);

TIntegerEditZone
	      IntegerEditZone
				  (&EditZoneTab,
				   52,4,
				   -50,0,
				   "~Integer Edit Zone (enter any integer value) :",
				   15,255,
				   0,10);

TDecimalEditZone
	      DecimalEditZone
				  (&EditZoneTab,
				   52,5,
				   -50,0,
				   "~Decimal Edit Zone (enter any decimal value) :",
				   15,255,
				   -3.2,10.5);


TTextZone     TextZone            (&EditZoneTab,
				   2,7,
				   68,6,
				   "~Text Zone",
				   255);

//-- LISTS ------------------------------------------------------------------

TTab	      ListTab	          (&TabGroup,
				   "~Lists");

TListItem     ListBoxItems[]=     {{"Item 1",LI_NOATTR},
				   {"Item 2",LI_NOATTR},
				   {"Item 3",LI_DISABLED},
				   {SEPARATOR,LI_NOATTR},
				   {"Items",LI_NOATTR},
				   {"are not",LI_NOATTR},
				   {"automatically",LI_NOATTR},
				   {"sorted",LI_NOATTR},
				   {NULL,LI_NOATTR}};

TListBox      ListBox             (&ListTab,
				  2,2,
				  20,10,
				  "List Bo~x",
				  ListBoxItems);


TListItem     SortedListBoxItems[]=
				  {{"Item 1",LI_NOATTR},
				   {"Item 2",LI_NOATTR},
				   {"Item 3",LI_DISABLED},
				   {SEPARATOR,LI_NOATTR},
				   {"Items"},
				   {"are",LI_NOATTR},
				   {"automatically",LI_NOATTR},
				   {"sorted",LI_NOATTR},
				   {NULL,LI_NOATTR}};


TListBox      SortedListBox       (&ListTab,
				  24,2,
				  20,10,
				  "~Sorted List Box",
				  SortedListBoxItems,
				  SORTED);

TListItem     CheckListBoxItems[]={{"Any item can be"  ,LI_NOATTR},
				   {"checked and can"  ,LI_CHECKED},
				   {"be a toggle or "  ,LI_TOGGLE},
				   {"not"              ,LI_CHECKED},
				   {SEPARATOR          ,LI_NOATTR},
				   {"It's a toggle"    ,LI_TOGGLE|LI_CHECKED},
				   {"It's not a toggle",LI_NOATTR},
				   {SEPARATOR          ,LI_NOATTR},
				   {"Items can be"     ,LI_TOGGLE},
				   {"toggled by double",LI_TOGGLE},
				   {"clicking or by"   ,LI_TOGGLE},
				   {"pressing <SPACE>" ,LI_TOGGLE},
				   {NULL,LI_NOATTR}};

TListBox      CheckListBox       (&ListTab,
				  46,2,
				  23,10,
				  "~Check List Box",
				  CheckListBoxItems);

//-- MISC IN MAIN WINDOW-----------------------------------------------------

TTab	      MiscTab	          (&TabGroup,
				  "Mi~sc");

TFrame        Frame1              (&MiscTab,
				  2,2,
				  40,11,
				  "This is a ~Frame");

TPushButton   GaugeStartButton    (&Frame1,
				  13,2,12,
				  "~Push here");

TFrame        Frame2              (&Frame1,
				  2,4,
				  36,6,
				  "This is ~another Frame");

TGauge        Gauge               (&Frame2,
				  2,2,32,
				  "Gauge : work in progress");


TLabel        ComboBoxLabel       (&MiscTab,
                                   45,3,
                                   "Combo-Boxes :");

TComboBox     ComboBox1           (&MiscTab,
				   45,6,
				   0,-1,
				   "F~ree string",
				   15,20,
				   "Free String",
				   6,
				   ListBoxItems,
				   STRING_NEEDNT_TO_BE_IN_LIST,
				   NOT_SORTED,
				   ENABLED);

TComboBox     ComboBox2           (&MiscTab,
				   45,9,
				   0,-1,
				   "S~tring in list",
				   15,20,
				   "Free String",
				   6,
				   SortedListBoxItems,
				   STRING_MUST_BE_IN_LIST,
				   SORTED,
				   ENABLED);

//-- HELP WINDOWS ------------------------------------------------------------

TWindow       Help1Window          (HELP,
				  20,13,36,10,
				  "Help 1 : Modeless/movable window",
				  NO_INFO_BAR,
				  NOT_MODAL,
				  MOVABLE);


TWindow       Help2Window         (ALERT,
				  45,15,36,10,
				  "Help 2 : Modeless/unmovable window",
				  NO_INFO_BAR,
				  NOT_MODAL,
				  NOT_MOVABLE);

TLabel        Help1WindowLabel     (&Help1Window,
				   2,2,
				   "You can switch from a\n"\
				   "modeless window to\n"   \
				   "another one by clicking\n"   \
				   "on another window  \n"   \
				   "or by pressing\n"\
				   "ALT-F6");

TLabel        Help2WindowLabel     (&Help2Window,
				   2,2,
				   "No help available");

void DialogMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
{
  char str[30];

  switch (item_nb)
    {
      case 1 : MessageBox("Message Box ","This is a message box",ALERT,MB_ICONSTOP);
	       MessageBox("","This is another message box",HELP,MB_ICONINFORMATION|MB_ABORTRETRYIGNORE);
	       break;
      case 2 : InputBox("Input Box","Please enter what you want\n"\
				    "(ALT-BACKSPACE to return to\n"\
				    "default value) :",DIALOG1,
			"Default Value",30,str);
	       break;
      case 4 : MessageBox("You have chosen : ",
			  FileSelectionBox("Load","*.*"),
			  DIALOG1);
    }

}

void SetCirrusLogicMode132x25()
{
  union REGS regs;

  regs.x.ax=0x14;
  int86(0x10, &regs, &regs);
}

void SetCirrusLogicMode132x43()
{
  union REGS regs;

  regs.x.ax=0x54;
  int86(0x10, &regs, &regs);
}

void OptionMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
{
  static int old_selected_mode=4;

  switch (item_nb)
    {
      case 1 : GraphicalMousePointer(OptionMenu.m_item_is_checked(item_nb));
	       break;

      case 3 : SetTextMode(TEXTMODE_80x25_8);  		  break;
      case 4 : SetTextMode(TEXTMODE_80x25_9);             break;
      case 5 : SetTextMode(TEXTMODE_80x28_8);  		  break;
      case 6 : SetTextMode(TEXTMODE_80x28_9);  		  break;
      case 7 : SetTextMode(TEXTMODE_80x50_8);  		  break;
      case 8 : SetTextMode(TEXTMODE_80x50_9);  		  break;
      case 9 : SetUserTextMode(SetCirrusLogicMode132x25); break;
      case 10: SetUserTextMode(SetCirrusLogicMode132x43); break;

      case 12: if (OptionMenu.m_item_is_checked(item_nb))
		 DEBUG_SHOW_MEMORY();
	       else
		 DEBUG_HIDE_MEMORY();
	       break;

    }

  if ((item_nb>=3) && (item_nb<=10))
    {
      OptionMenu.m_uncheck_item(old_selected_mode);
      old_selected_mode=item_nb;
      OptionMenu.m_check_item(old_selected_mode);
    }
}

void LanguageMenuItemClickedCall(PObject /*sender*/,int item_nb,char */*arg*/)
{
  switch (item_nb)
    {
      case 1 : if (MessageBox(GetString(VOC_LANGUAGE),
			      GetString(VOC_HELLO),
			      DIALOG1,MB_ICONEXCLAMATION|MB_OKCANCEL)
		   ==CANCEL_BUTTON)
		 break;

	       LoadVocabulary(GERMAN);

	       if (MessageBox(GetString(VOC_LANGUAGE),
			      GetString(VOC_HELLO),
			      DIALOG1,MB_ICONEXCLAMATION|MB_OKCANCEL)
		   ==CANCEL_BUTTON)
		 break;

	       LoadVocabulary(FRENCH);

	       if (MessageBox(GetString(VOC_LANGUAGE),
			      GetString(VOC_HELLO),
			      DIALOG1,MB_ICONEXCLAMATION|MB_OKCANCEL)
		   ==CANCEL_BUTTON)
		 break;
    }

  LoadVocabulary(ENGLISH);
}

void HelpMenuItemClickedCall(PObject /*sender*/,int /*item_nb*/,char */*arg*/)
{
  Help1Window.m_close();
  Help1Window.m_open();
  Help2Window.m_close();
  Help2Window.m_open();
}

void GaugeStartButtonPressedCall(PObject /*sender*/, char */*arg*/)
{

  long value=Gauge.m_get_value();
  int inc=(value==0)?1:-1;

  value+=inc;

  while ((value>=0) && (value<=100))
    {
      Gauge.m_set_value(value);
      JPRefresh();
      delay(10);
      value+=inc;
    }
}

void QuitCall(PObject /*sender*/,char */*arg*/)
{
  JPStop();
}

int main(int argc, char* argv[])
{
  if (argc>1)
    if (!strcmp(argv[1],"/?"))
      {
	cout << "This is a demo of what you can do with JPTUI " << VERSION << "." << SUB_VERSION << "\n" \
		"(Jeepy Text User Interface).\n\n"   \
		"Simply type JPDEMO to run it.\n\n";
	exit(EXIT_SUCCESS);
      }

  JPInit();

  MainWindow.m_set_close_button_pressed_callback(QuitCall,"");
  QuitButton.m_set_pressed_callback(QuitCall,"");

  DialogBoxesMenu.m_set_item_clicked_callback(DialogMenuItemClickedCall,"");
  OptionMenu.m_set_item_clicked_callback(OptionMenuItemClickedCall,"");
  LanguageMenu.m_set_item_clicked_callback(LanguageMenuItemClickedCall,"");
  HelpMenu.m_set_item_clicked_callback(HelpMenuItemClickedCall,"");

  GaugeStartButton.m_set_pressed_callback(GaugeStartButtonPressedCall,"");

  TextZone.m_insert_text("CTRL-Y to delete a line\n" \
			"CTRL-INS,SHIFT_DEL & SHIFT_INSERT to copy, cut and paste\n\n"\
			"Type whatever you want and as much as you want...");

  MainWindow.m_open();

  JPRun();

  exit(EXIT_SUCCESS);
  return(0);

}
